//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * @eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/DimensionITest.h"
#include "Core/Primitive/DimensionI.h"
#include "Core/Primitive/DimensionF.h"

//------------------------------------------------------------------------------
// RXgN^
DimensionITest::DimensionITest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* DimensionITest::suite(){
	TestSuite* suite = new TestSuite("DimensionITest");
	suite->addTest(new TestCaller(DimensionITest, testConstructor));
	suite->addTest(new TestCaller(DimensionITest, testFixedNumber));
	suite->addTest(new TestCaller(DimensionITest, testSetValue));
	suite->addTest(new TestCaller(DimensionITest, testArithmetic));
	suite->addTest(new TestCaller(DimensionITest, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(DimensionITest, testLogicalOperation));
	suite->addTest(new TestCaller(DimensionITest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void DimensionITest::testConstructor(){
	TestEquals(8, (int)sizeof(DimensionI));
	DimensionI dimension0(64, 128);
	TestEquals(64, dimension0.width);
	TestEquals(128, dimension0.height);
	TestEquals(64, dimension0.array[0]);
	TestEquals(128, dimension0.array[1]);
	DimensionI dimension1(0, 1);
	TestEquals(0, dimension1.width);
	TestEquals(1, dimension1.height);
	dimension1 = dimension0;
	TestEquals(64, dimension1.width);
	TestEquals(128, dimension1.height);
	int array[] = { 64, 128 };
	DimensionI dimension2(array);
	TestAssert(dimension0 == dimension2);
	DimensionI dimension3(DimensionF(64.f, 128.f));
	TestAssert(DimensionI(64, 128) == dimension3);
}
//------------------------------------------------------------------------------
// 萔eXg
void DimensionITest::testFixedNumber(){
	TestAssert(DimensionI(0, 0) == DimensionI::zero);
	TestAssert(DimensionI(1, 1) == DimensionI::unit);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void DimensionITest::testSetValue(){
	DimensionI dimension0(0, 0);
	dimension0.set(1, 1);
	TestAssert(DimensionI::unit == dimension0);
	int array[] = { 0, 0 };
	dimension0.set(array);
	TestAssert(DimensionI::zero == dimension0);
	dimension0.set(DimensionF(64.f, 128.f));
	TestAssert(DimensionI(64, 128) == dimension0);
}
//------------------------------------------------------------------------------
// Z
void DimensionITest::testArithmetic(){
	// Z
	DimensionI dimension0(64, 64), dimension1(16, 32), dimension2;
	dimension2 = dimension0 + dimension1;
	TestAssert(DimensionI(80, 96) == dimension2);
	// Z
	dimension2 = dimension2 - dimension1;
	TestAssert(dimension0 == dimension2);
	// Z
	dimension0.set(4, 4);
	dimension1.set(3, 4);
	dimension2 = dimension0 * dimension1;
	TestAssert(DimensionI(12, 16) == dimension2);
	dimension0 = dimension2 * 0.5f;
	TestAssert(DimensionI(6, 8) == dimension0);
	dimension1 = 0.5f * dimension2;
	TestAssert(dimension0 == dimension1);
	dimension0 = dimension0 * 2;
	TestAssert(dimension2 == dimension0);
	dimension1 = 2 * dimension1;
	TestAssert(dimension2 == dimension1);
	// +-Zq
	dimension0.set(-dimension0.width, -dimension0.height);
	dimension1 = -dimension1;
	TestAssert(dimension0 == dimension1);
	dimension2 = +dimension0;
	TestAssert(dimension0 == dimension2);
}
//------------------------------------------------------------------------------
// Z
void DimensionITest::testSubstitutionArithmetic(){
	// Z
	DimensionI dimension0(64, 64), dimension1(16, 32);
	dimension0 += dimension1;
	TestAssert(DimensionI(80, 96) == dimension0);
	// Z
	dimension0 -= dimension1;
	TestAssert(DimensionI(64, 64) == dimension0);
	// Z
	dimension0.set(4, 4);
	dimension1.set(3, 4);
	dimension0 *= dimension1;
	TestAssert(DimensionI(12, 16) == dimension0);
	dimension0 *= 0.5f;
	TestAssert(DimensionI(6, 8) == dimension0);
	dimension0 *= 2;
	TestAssert(DimensionI(12, 16) == dimension0);
}
//------------------------------------------------------------------------------
// _ZeXg
void DimensionITest::testLogicalOperation(){
	DimensionI dimension0(64, 128), dimension1(64, 128);
	TestAssert(dimension0 == dimension1);
	TestAssert(!(dimension0 != dimension1));
	dimension1.width = 96;
	TestAssert(!(dimension0 == dimension1));
	TestAssert(dimension0 != dimension1);
}
//------------------------------------------------------------------------------
// eXg
void DimensionITest::testToString(){
	DimensionI dimension0(64, 128);
	TestEquals("( 64, 128 )", dimension0.toString());
}
//------------------------------------------------------------------------------
