//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * @eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/DimensionFTest.h"
#include "Core/Primitive/DimensionF.h"
#include "Core/Primitive/DimensionI.h"

//------------------------------------------------------------------------------
// RXgN^
DimensionFTest::DimensionFTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* DimensionFTest::suite(){
	TestSuite* suite = new TestSuite("DimensionFTest");
	suite->addTest(new TestCaller(DimensionFTest, testConstructor));
	suite->addTest(new TestCaller(DimensionFTest, testFixedNumber));
	suite->addTest(new TestCaller(DimensionFTest, testSetValue));
	suite->addTest(new TestCaller(DimensionFTest, testArithmetic));
	suite->addTest(new TestCaller(DimensionFTest, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(DimensionFTest, testLogicalOperation));
	suite->addTest(new TestCaller(DimensionFTest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void DimensionFTest::testConstructor(){
	TestEquals(8, (int)sizeof(DimensionF));
	DimensionF dimension0(64.f, 128.f);
	TestEquals(64.f, dimension0.width);
	TestEquals(128.f, dimension0.height);
	TestEquals(64.f, dimension0.array[0]);
	TestEquals(128.f, dimension0.array[1]);
	DimensionF dimension1(0.f, 1.f);
	TestEquals(0.f, dimension1.width);
	TestEquals(1.f, dimension1.height);
	dimension1 = dimension0;
	TestEquals(64.f, dimension1.width);
	TestEquals(128.f, dimension1.height);
	float array[] = { 64.f, 128.f };
	DimensionF dimension2(array);
	TestAssert(dimension0 == dimension2);
	DimensionF dimension3(DimensionI(64, 128));
	TestAssert(DimensionF(64.f, 128.f) == dimension3);
}
//------------------------------------------------------------------------------
// 萔eXg
void DimensionFTest::testFixedNumber(){
	TestAssert(DimensionF(0.f, 0.f) == DimensionF::zero);
	TestAssert(DimensionF(1.f, 1.f) == DimensionF::unit);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void DimensionFTest::testSetValue(){
	DimensionF dimension0(0.f, 0.f);
	dimension0.set(1.f, 1.f);
	TestAssert(DimensionF::unit == dimension0);
	float array[] = { 0.f, 0.f };
	dimension0.set(array);
	TestAssert(DimensionF::zero == dimension0);
	dimension0.set(DimensionI(64, 128));
	TestAssert(DimensionF(64.f, 128.f) == dimension0);
}
//------------------------------------------------------------------------------
// Z
void DimensionFTest::testArithmetic(){
	// Z
	DimensionF dimension0(64.f, 64.f), dimension1(16.f, 32.f), dimension2;
	dimension2 = dimension0 + dimension1;
	TestAssert(DimensionF(80.f, 96.f) == dimension2);
	// Z
	dimension2 = dimension2 - dimension1;
	TestAssert(dimension0 == dimension2);
	// Z
	dimension0.set(4.f, 4.f);
	dimension1.set(3.f, 4.f);
	dimension2 = dimension0 * dimension1;
	TestAssert(DimensionF(12.f, 16.f) == dimension2);
	dimension0 = dimension2 * 0.5f;
	TestAssert(DimensionF(6.f, 8.f) == dimension0);
	dimension1 = 0.5f * dimension2;
	TestAssert(dimension0 == dimension1);
	// +-Zq
	dimension0.set(-dimension0.width, -dimension0.height);
	dimension1 = -dimension1;
	TestAssert(dimension0 == dimension1);
	dimension2 = +dimension0;
	TestAssert(dimension0 == dimension2);
}
//------------------------------------------------------------------------------
// Z
void DimensionFTest::testSubstitutionArithmetic(){
	// Z
	DimensionF dimension0(64.f, 64.f), dimension1(16.f, 32.f);
	dimension0 += dimension1;
	TestAssert(DimensionF(80.f, 96.f) == dimension0);
	// Z
	dimension0 -= dimension1;
	TestAssert(DimensionF(64.f, 64.f) == dimension0);
	// Z
	dimension0.set(4.f, 4.f);
	dimension1.set(3.f, 4.f);
	dimension0 *= dimension1;
	TestAssert(DimensionF(12, 16) == dimension0);
	dimension0 *= 0.5f;
	TestAssert(DimensionF(6, 8) == dimension0);
}
//------------------------------------------------------------------------------
// _ZeXg
void DimensionFTest::testLogicalOperation(){
	DimensionF dimension0(64.f, 128.f), dimension1(64.f, 128.f);
	TestAssert(dimension0 == dimension1);
	TestAssert(!(dimension0 != dimension1));
	dimension1.width += Math::epsilon;
	TestAssert(dimension0.epsilonEquals(dimension1, Math::epsilon));
	TestAssert(!dimension0.notEpsilonEquals(dimension1, Math::epsilon));
	dimension1.width += 0.0001f;
	TestAssert(!dimension0.epsilonEquals(dimension1, Math::epsilon));
	TestAssert(dimension0.notEpsilonEquals(dimension1, Math::epsilon));
	dimension1.width = 96.f;
	TestAssert(!(dimension0 == dimension1));
	TestAssert(dimension0 != dimension1);
}
//------------------------------------------------------------------------------
// eXg
void DimensionFTest::testToString(){
	DimensionF dimension0(64, 128);
	TestEquals("( 64.00000000, 128.00000000 )", dimension0.toString());
}
//------------------------------------------------------------------------------
