//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * v~eBueXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/CorePrimitiveAllTests.h"
#include "Core/Primitive/StringTest.h"
#include "Core/Primitive/BitSetTest.h"
#include "Core/Primitive/Color3cTest.h"
#include "Core/Primitive/Color4cTest.h"
#include "Core/Primitive/Color3fTest.h"
#include "Core/Primitive/Color4fTest.h"
#include "Core/Primitive/DimensionITest.h"
#include "Core/Primitive/DimensionFTest.h"
#include "Core/Primitive/RectangleITest.h"
#include "Core/Primitive/RectangleFTest.h"
#include "Core/Primitive/Vector3Test.h"
#include "Core/Primitive/Matrix33Test.h"
#include "Core/Primitive/Matrix34Test.h"
#include "Core/Primitive/Matrix44Test.h"
#include "Core/Primitive/QuaternionTest.h"
#include "Core/Primitive/TexCoord1Test.h"
#include "Core/Primitive/TexCoord2Test.h"
#include "Core/Primitive/TexCoord3Test.h"
#include "Core/Primitive/TexCoord4Test.h"

//------------------------------------------------------------------------------
// RXgN^
CorePrimitiveAllTests::CorePrimitiveAllTests() :
	TestSuite("CorePrimitiveAllTests"){
	// ̃eXg
	addTest(StringTest::suite());
	// rbgZbg̃eXg
	addTest(BitSetTest::suite());
	// OvfLN^J[̃eXg
	addTest(Color3cTest::suite());
	// lvfLN^J[̃eXg
	addTest(Color4cTest::suite());
	// OvfJ[̃eXg
	addTest(Color3fTest::suite());
	// lvfJ[̃eXg
	addTest(Color4fTest::suite());
	// @̃eXg
	addTest(DimensionITest::suite());
	// @̃eXg
	addTest(DimensionFTest::suite());
	// `eXg
	addTest(RectangleITest::suite());
	// `eXg
	addTest(RectangleFTest::suite());
	// OxNg̃eXg
	addTest(Vector3Test::suite());
	// 3~3s̃eXg
	addTest(Matrix33Test::suite());
	// 3~4s̃eXg
	addTest(Matrix34Test::suite());
	// 4~4s̃eXg
	addTest(Matrix44Test::suite());
	// l̃eXg
	addTest(QuaternionTest::suite());
	// ꎟeNX`W̃eXg
	addTest(TexCoord1Test::suite());
	// 񎟌eNX`W̃eXg
	addTest(TexCoord2Test::suite());
	// OeNX`W̃eXg
	addTest(TexCoord3Test::suite());
	// leNX`W̃eXg
	addTest(TexCoord4Test::suite());
}
//------------------------------------------------------------------------------
