//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * lvfLN^J[eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/Color4cTest.h"
#include "Core/Primitive/Color4c.h"
#include "Core/Primitive/Color3c.h"
#include "Core/Primitive/Color3f.h"
#include "Core/Primitive/Color4f.h"

//------------------------------------------------------------------------------
// RXgN^
Color4cTest::Color4cTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* Color4cTest::suite(){
	TestSuite* suite = new TestSuite("Color4cTest");
	suite->addTest(new TestCaller(Color4cTest, testConstructor));
	suite->addTest(new TestCaller(Color4cTest, testFixedNumber));
	suite->addTest(new TestCaller(Color4cTest, testSetValue));
	suite->addTest(new TestCaller(Color4cTest, testArithmetic));
	suite->addTest(new TestCaller(Color4cTest, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(Color4cTest, testColorArithmetic));
	suite->addTest(new TestCaller(Color4cTest, testLogicalOperation));
	suite->addTest(new TestCaller(Color4cTest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void Color4cTest::testConstructor(){
	TestEquals(4, (int)sizeof(Color4c));
	Color4c col0(64, 128, 192, 0);
	TestEquals(64, col0.r);
	TestEquals(128, col0.g);
	TestEquals(192, col0.b);
	TestEquals(0, col0.a);
	TestEquals(64, col0.array[0]);
	TestEquals(128, col0.array[1]);
	TestEquals(192, col0.array[2]);
	TestEquals(0, col0.array[3]);
	TestEquals(0x004080c0u, col0.getARGB());
	Color4c col1(0, 1, 2);
	TestEquals(0, col1.r);
	TestEquals(1, col1.g);
	TestEquals(2, col1.b);
	TestEquals(255, col1.a);
	col1 = col0;
	TestEquals(64, col1.r);
	TestEquals(128, col1.g);
	TestEquals(192, col1.b);
	TestEquals(0, col1.a);
	Color4c col2(Color3c(64, 128, 192));
	TestAssert(Color4c(64, 128, 192, 255) == col2);
	Color4c col3(Color3f(0.5f, 2.f, -1.f));
	TestAssert(Color4c(127, 255, 0, 255) == col3);
	Color4c col4(Color4f(0.5f, 2.f, -1.f, 0.5f));
	TestAssert(Color4c(127, 255, 0, 127) == col4);
}
//------------------------------------------------------------------------------
// 萔eXg
void Color4cTest::testFixedNumber(){
	TestAssert(Color4c(255, 255, 255) == Color4c::white);
	TestAssert(Color4c(128, 128, 128) == Color4c::gray);
	TestAssert(Color4c(0, 0, 0) == Color4c::black);
	TestAssert(Color4c(255, 0, 0) == Color4c::red);
	TestAssert(Color4c(0, 255, 0) == Color4c::green);
	TestAssert(Color4c(0, 0, 255) == Color4c::blue);
	TestAssert(Color4c(255, 255, 0) == Color4c::yellow);
	TestAssert(Color4c(0, 255, 255) == Color4c::cyan);
	TestAssert(Color4c(255, 0, 255) == Color4c::magenta);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void Color4cTest::testSetValue(){
	Color4c col0;
	col0.set(255, 255, 255);
	TestAssert(Color4c::white == col0);
	col0.set(255, 255, 255, 254);
	TestAssert(Color4c::white != col0);
	// OvfLN^J[̐ݒ
	col0.set(Color3c(64, 128, 192));
	TestAssert(Color4c(64, 128, 192, 255) == col0);
	// OvfJ[̐ݒ
	col0.set(Color3f(0.5f, 2.f, -1.f));
	TestAssert(Color4c(127, 255, 0, 255) == col0);
	// lvfJ[̐ݒ
	col0.set(Color4f(0.5f, 2.f, -1.f, 0.5f));
	TestAssert(Color4c(127, 255, 0, 127) == col0);
}
//------------------------------------------------------------------------------
// Z
void Color4cTest::testArithmetic(){
	// Z
	Color4c col0(64, 64, 64, 64), col1(16, 32, 48, 64), col2;
	col2 = col0 + col1;
	TestAssert(Color4c(80, 96, 112, 128) == col2);
	// Z
	col2 = col2 - col1;
	TestAssert(col0 == col2);
	// Z
	col0.set(128, 128, 128, 128);
	col0 = col0 * col0;
	TestAssert(Color4c(64, 64, 64, 64) == col0);
	col0 = col0 * 2.f;
	TestAssert(Color4c(128, 128, 128, 128) == col0);
	col0 = 0.5f * col0;
	TestAssert(Color4c(64, 64, 64, 64) == col0);
}
//------------------------------------------------------------------------------
// Z
void Color4cTest::testSubstitutionArithmetic(){
	// Z
	Color4c col0(64, 64, 64, 64), col1(16, 32, 48, 64);
	col0 += col1;
	TestAssert(Color4c(80, 96, 112, 128) == col0);
	// Z
	col0 -= col1;
	TestAssert(Color4c(64, 64, 64, 64) == col0);
	// Z
	col0.set(128, 128, 128, 128);
	col0 *= col0;
	TestAssert(Color4c(64, 64, 64, 64) == col0);
	col0 *=2.f;
	TestAssert(Color4c(128, 128, 128, 128) == col0);
}
//------------------------------------------------------------------------------
// FZ
void Color4cTest::testColorArithmetic(){
	// ΐF
	Color4c negColor(64, 128, 192, 255);
	negColor.negative();
	TestAssert(Color4c(191, 127, 63, 255) == negColor);
	// `
	Color4c col0(0, 0, 0, 0), col1(64, 64, 64, 64);
	for(int i = 0; i < 11; i++){
		float alpha = i * 0.1f;
		u_char value = (u_char)(alpha * 64.f);
		Color4c answer(value, value, value, value);
		Color4c result = Color4c::lerp(col0, col1, alpha);
		TestAssert(answer == result);
	}
}
//------------------------------------------------------------------------------
// _ZeXg
void Color4cTest::testLogicalOperation(){
	Color4c col0(64, 128, 192), col1(64, 128, 192);
	TestAssert(col0 == col1);
	TestAssert(!(col0 != col1));
	col1.r = 96;
	TestAssert(!(col0 == col1));
	TestAssert(col0 != col1);
}
//------------------------------------------------------------------------------
// eXg
void Color4cTest::testToString(){
	Color4c col0(64, 128, 192);
	TestEquals("( 64, 128, 192, 255 )", col0.toString());
}
//------------------------------------------------------------------------------
