//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OvfLN^J[eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Primitive/Color3cTest.h"
#include "Core/Primitive/Color3c.h"
#include "Core/Primitive/Color4c.h"
#include "Core/Primitive/Color3f.h"
#include "Core/Primitive/Color4f.h"

//------------------------------------------------------------------------------
// RXgN^
Color3cTest::Color3cTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* Color3cTest::suite(){
	TestSuite* suite = new TestSuite("Color3cTest");
	suite->addTest(new TestCaller(Color3cTest, testConstructor));
	suite->addTest(new TestCaller(Color3cTest, testFixedNumber));
	suite->addTest(new TestCaller(Color3cTest, testSetValue));
	suite->addTest(new TestCaller(Color3cTest, testArithmetic));
	suite->addTest(new TestCaller(Color3cTest, testSubstitutionArithmetic));
	suite->addTest(new TestCaller(Color3cTest, testColorArithmetic));
	suite->addTest(new TestCaller(Color3cTest, testLogicalOperation));
	suite->addTest(new TestCaller(Color3cTest, testToString));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void Color3cTest::testConstructor(){
	TestEquals(3, (int)sizeof(Color3c));
	Color3c col0(64, 128, 192);
	TestEquals(64, col0.r);
	TestEquals(128, col0.g);
	TestEquals(192, col0.b);
	TestEquals(64, col0.array[0]);
	TestEquals(128, col0.array[1]);
	TestEquals(192, col0.array[2]);
	TestEquals(0xff4080c0u, col0.getARGB());
	Color3c col1(0, 1, 2);
	TestEquals(0, col1.r);
	TestEquals(1, col1.g);
	TestEquals(2, col1.b);
	col1 = col0;
	TestEquals(64, col1.r);
	TestEquals(128, col1.g);
	TestEquals(192, col1.b);
	Color3c col2(Color4c(64, 128, 192, 128));
	TestAssert(Color3c(64, 128, 192) == col2);
	Color3c col3(Color3f(0.5f, 2.f, -1.f));
	TestAssert(Color3c(127, 255, 0) == col3);
	Color3c col4(Color4f(0.5f, 2.f, -1.f, 0.5f));
	TestAssert(Color3c(127, 255, 0) == col4);
}
//------------------------------------------------------------------------------
// 萔eXg
void Color3cTest::testFixedNumber(){
	TestAssert(Color3c(255, 255, 255) == Color3c::white);
	TestAssert(Color3c(128, 128, 128) == Color3c::gray);
	TestAssert(Color3c(0, 0, 0) == Color3c::black);
	TestAssert(Color3c(255, 0, 0) == Color3c::red);
	TestAssert(Color3c(0, 255, 0) == Color3c::green);
	TestAssert(Color3c(0, 0, 255) == Color3c::blue);
	TestAssert(Color3c(255, 255, 0) == Color3c::yellow);
	TestAssert(Color3c(0, 255, 255) == Color3c::cyan);
	TestAssert(Color3c(255, 0, 255) == Color3c::magenta);
}
//------------------------------------------------------------------------------
// l̐ݒeXg
void Color3cTest::testSetValue(){
	Color3c col0;
	col0.set(255, 255, 255);
	TestAssert(Color3c::white == col0);
	col0.set(255, 255, 254);
	TestAssert(Color3c::white != col0);
	// lvfLN^J[̐ݒ
	col0.set(Color4c(64, 128, 192, 128));
	TestAssert(Color3c(64, 128, 192) == col0);
	// OvfJ[̐ݒ
	col0.set(Color3f(0.5f, 2.f, -1.f));
	TestAssert(Color3c(127, 255, 0) == col0);
	// lvfJ[̐ݒ
	col0.set(Color4f(0.5f, 2.f, -1.f, 0.5f));
	TestAssert(Color3c(127, 255, 0) == col0);
}
//------------------------------------------------------------------------------
// Z
void Color3cTest::testArithmetic(){
	// Z
	Color3c col0(64, 64, 64), col1(16, 32, 48), col2;
	col2 = col0 + col1;
	TestAssert(Color3c(80, 96, 112) == col2);
	// Z
	col2 = col2 - col1;
	TestAssert(col0 == col2);
	// Z
	col0.set(128, 128, 128);
	col0 = col0 * col0;
	TestAssert(Color3c(64, 64, 64) == col0);
	col0 = col0 * 2.f;
	TestAssert(Color3c(128, 128, 128) == col0);
	col0 = 0.5f * col0;
	TestAssert(Color3c(64, 64, 64) == col0);
}
//------------------------------------------------------------------------------
// Z
void Color3cTest::testSubstitutionArithmetic(){
	// Z
	Color3c col0(64, 64, 64), col1(16, 32, 48);
	col0 += col1;
	TestAssert(Color3c(80, 96, 112) == col0);
	// Z
	col0 -= col1;
	TestAssert(Color3c(64, 64, 64) == col0);
	// Z
	col0.set(128, 128, 128);
	col0 *= col0;
	TestAssert(Color3c(64, 64, 64) == col0);
	col0 *=2.f;
	TestAssert(Color3c(128, 128, 128) == col0);
}
//------------------------------------------------------------------------------
// FZ
void Color3cTest::testColorArithmetic(){
	// ΐF
	Color3c negColor(64, 128, 192);
	negColor.negative();
	TestAssert(Color3c(191, 127, 63) == negColor);
	// `
	Color3c col0(0, 0, 0), col1(64, 64, 64);
	for(int i = 0; i < 11; i++){
		float alpha = i * 0.1f;
		u_char value = (u_char)(alpha * 64.f);
		Color3c answer(value, value, value);
		Color3c result = Color3c::lerp(col0, col1, alpha);
		TestAssert(answer == result);
	}
}
//------------------------------------------------------------------------------
// _ZeXg
void Color3cTest::testLogicalOperation(){
	Color3c col0(64, 128, 192), col1(64, 128, 192);
	TestAssert(col0 == col1);
	TestAssert(!(col0 != col1));
	col1.r = 96;
	TestAssert(!(col0 == col1));
	TestAssert(col0 != col1);
}
//------------------------------------------------------------------------------
// eXg
void Color3cTest::testToString(){
	Color3c col0(64, 128, 192);
	TestEquals("( 64, 128, 192 )", col0.toString());
}
//------------------------------------------------------------------------------
