//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgo̓eXgwb_
 * @author Junpee
 */

#ifndef TEXT_IO_TEST_H_
#define TEXT_IO_TEST_H_

#include <LampUnit/TestCase.h>

namespace Lamp{
	class TextWriter;
	class TextReader;
}

//------------------------------------------------------------------------------
/**
 * eLXgo̓eXg
 */
class TextIOTest : public TestCase{
public:
	/**
	 * RXgN^
	 * @param name eXg̖O
	 */
	explicit TextIOTest(String name) : TestCase(name){}

	/**
	 * eXgs
	 */
	virtual void runTest(){}

	/**
	 * eXgXB[g̎擾
	 * @return eXgXB[g
	 */
	static Test* suite();

	// t@Co̓eXg
	virtual void testFileIO();

	// o̓eXg
	virtual void testMemoryIO();

private:
	// ʏ폑
	virtual void basicWrite(TextWriter* writer);

	// ʏǂݍ
	virtual void basicRead(TextReader* reader);

	// CRLF
	virtual void crlfWrite(TextWriter* writer);

	// CRLFǂݍ
	virtual void crlfRead(TextReader* reader);

	// CR
	virtual void crWrite(TextWriter* writer);

	// CRǂݍ
	virtual void crRead(TextReader* reader);

	// LF
	virtual void lfWrite(TextWriter* writer);

	// LFǂݍ
	virtual void lfRead(TextReader* reader);

	// abc
	virtual void abcWrite(TextWriter* writer);

	// abcǂݍ
	virtual void abcRead(TextReader* reader);

	// 󏑂
	virtual void emptyWrite(TextWriter* writer);

	// ǂݍ
	virtual void emptyRead(TextReader* reader);

};

//------------------------------------------------------------------------------
#endif // End of TEXT_IO_TEST_H_
//------------------------------------------------------------------------------
