//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgo̓eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/InputOutput/TextIOTest.h"
#include <Core/InputOutput/TextFileWriter.h>
#include <Core/InputOutput/TextFileReader.h>
#include <Core/InputOutput/TextMemoryWriter.h>
#include <Core/InputOutput/TextMemoryReader.h>

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TextIOTest::suite(){
	TestSuite* suite = new TestSuite("TextIOTest");
	suite->addTest(new TestCaller(TextIOTest, testFileIO));
	suite->addTest(new TestCaller(TextIOTest, testMemoryIO));
	return suite;
}
//------------------------------------------------------------------------------
// t@Co̓eXg
void TextIOTest::testFileIO(){
	TextFileWriter* writer;
	TextFileReader* reader;
	// ʏǂݏ
	writer = new TextFileWriter(
		"Resource/Temporary/TextIOTest_testFileIO_0.txt");
	basicWrite(writer);
	delete writer;
	reader = new TextFileReader(
		"Resource/Temporary/TextIOTest_testFileIO_0.txt");
	basicRead(reader);
	delete reader;

	// CRLFsR[h
	writer = new TextFileWriter(
		"Resource/Temporary/TextIOTest_testFileIO_1.txt");
	crlfWrite(writer);
	delete writer;
	reader = new TextFileReader(
		"Resource/Temporary/TextIOTest_testFileIO_1.txt");
	crlfRead(reader);
	delete reader;

	// CRsR[h
	writer = new TextFileWriter(
		"Resource/Temporary/TextIOTest_testFileIO_2.txt");
	crWrite(writer);
	delete writer;
	reader = new TextFileReader(
		"Resource/Temporary/TextIOTest_testFileIO_2.txt");
	crRead(reader);
	delete reader;

	// LFsR[h
	writer = new TextFileWriter(
		"Resource/Temporary/TextIOTest_testFileIO_3.txt");
	lfWrite(writer);
	delete writer;
	reader = new TextFileReader(
		"Resource/Temporary/TextIOTest_testFileIO_3.txt");
	lfRead(reader);
	delete reader;

	// sR[h
	writer = new TextFileWriter(
		"Resource/Temporary/TextIOTest_testFileIO_4.txt");
	abcWrite(writer);
	delete writer;
	reader = new TextFileReader(
		"Resource/Temporary/TextIOTest_testFileIO_4.txt");
	abcRead(reader);
	delete reader;

	// 
	writer = new TextFileWriter(
		"Resource/Temporary/TextIOTest_testFileIO_5.txt");
	emptyWrite(writer);
	delete writer;
	reader = new TextFileReader(
		"Resource/Temporary/TextIOTest_testFileIO_5.txt");
	emptyRead(reader);
	delete reader;

}
//------------------------------------------------------------------------------
// o̓eXg
void TextIOTest::testMemoryIO(){
	// ʏǂݏ
	TextMemoryWriter* writer;
	TextMemoryReader* reader;
	writer = new TextMemoryWriter(1);
	basicWrite(writer);
	reader = new TextMemoryReader(writer->getBuffer(), writer->getSize());
	basicRead(reader);
	delete reader;
	delete writer;

	// CRLFsR[h
	writer = new TextMemoryWriter(1);
	crlfWrite(writer);
	reader = new TextMemoryReader(writer->getBuffer(), writer->getSize());
	crlfRead(reader);
	delete reader;
	delete writer;

	// CRsR[h
	writer = new TextMemoryWriter(1);
	crWrite(writer);
	reader = new TextMemoryReader(writer->getBuffer(), writer->getSize());
	crRead(reader);
	delete reader;
	delete writer;

	// LFsR[h
	writer = new TextMemoryWriter(1);
	lfWrite(writer);
	reader = new TextMemoryReader(writer->getBuffer(), writer->getSize());
	lfRead(reader);
	delete reader;
	delete writer;

	// sR[h
	writer = new TextMemoryWriter(1);
	abcWrite(writer);
	reader = new TextMemoryReader(writer->getBuffer(), writer->getSize());
	abcRead(reader);
	delete reader;
	delete writer;

	// 
	writer = new TextMemoryWriter(1);
	emptyWrite(writer);
	reader = new TextMemoryReader(writer->getBuffer(), writer->getSize());
	emptyRead(reader);
	delete reader;
	delete writer;

}
//------------------------------------------------------------------------------
// ʏ폑
void TextIOTest::basicWrite(TextWriter* writer){
	writer->writeText("\nabc\n\n");
	writer->writeText("12345\n", 6);
	writer->writeFormat("%d %.1f %s\n\r", 1 ,2.34f, "4TU");
	writer->flush();
}
//------------------------------------------------------------------------------
// ʏǂݍ
void TextIOTest::basicRead(TextReader* reader){
	String string;
	string = reader->readLine();
	TestEquals("", string);
	string = reader->readLine();
	TestEquals("abc", string);
	string = reader->readLine();
	TestEquals("", string);
	string = reader->readLine();
	TestEquals("12345", string);
	string = reader->readLine();
	TestEquals("1 2.3 4TU", string);
	string = reader->readLine();
	TestEquals("", string);
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
// CRLF
void TextIOTest::crlfWrite(TextWriter* writer){
	writer->writeText("\r\n");
}
//------------------------------------------------------------------------------
// CRLFǂݍ
void TextIOTest::crlfRead(TextReader* reader){
	String string = reader->readLine();
	TestEquals("", string);
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
// CR
void TextIOTest::crWrite(TextWriter* writer){
	writer->writeText("\r");
}
//------------------------------------------------------------------------------
// CRǂݍ
void TextIOTest::crRead(TextReader* reader){
	String string = reader->readLine();
	TestEquals("", string);
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
// LF
void TextIOTest::lfWrite(TextWriter* writer){
	writer->writeText("\n");
}
//------------------------------------------------------------------------------
// LFǂݍ
void TextIOTest::lfRead(TextReader* reader){
	String string = reader->readLine();
	TestEquals("", string);
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
// abc
void TextIOTest::abcWrite(TextWriter* writer){
	writer->writeText("abc");
}
//------------------------------------------------------------------------------
// abcǂݍ
void TextIOTest::abcRead(TextReader* reader){
	String string = reader->readLine();
	TestEquals("abc", string);
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
// 󏑂
void TextIOTest::emptyWrite(TextWriter* writer){
}
//------------------------------------------------------------------------------
// ǂݍ
void TextIOTest::emptyRead(TextReader* reader){
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
