//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgRo[^eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/InputOutput/TextConverterTest.h"
#include "Core/InputOutput/TextConverter.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TextConverterTest::suite(){
	TestSuite* suite = new TestSuite("TextConverterTest");
	suite->addTest(new TestCaller(TextConverterTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {@\eXg
void TextConverterTest::testBasic(){
	String string("\\\"\t\v\b\f\a @\r\n%%\"\\"");
	TestEquals("\\\"\t\v\b\f\a @\r\n%%\"\\"", string);
//	checkString(string);
	String text = TextConverter::stringToText(string);
	TestEquals("\"\\\\\\\"\\t\\v\\b\\f\\a @\\r\\n%%\\\"\\\\"\"", text);
//	checkString(text);
	String newString = TextConverter::textToString(text);
	TestEquals("\\\"\t\v\b\f\a @\r\n%%\"\\"", newString);
//	checkString(newString);
//	DebugOut("\n");
//	DebugOutLine();
}
//------------------------------------------------------------------------------
// `FbN
void TextConverterTest::checkString(String string){
	DebugOut("\n");
	DebugOutLine();
	DebugOut(string.getBytes());
	DebugOut(" : Size = %d\n", string.getSize());
	for(int i = 0; i < string.getSize(); i++){
		DebugOut("  %d", i % 10);
	}
	DebugOut("\n");
	for(int i = 0; i < string.getSize(); i++){
		int data = (int)string.charAt(i) & 0xff;
		DebugOut(" %02x", data);
	}
}
//------------------------------------------------------------------------------
