//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgo̓eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/InputOutput/StreamTokenizerTest.h"
#include <Core/InputOutput/StreamTokenizer.h>
#include <Core/InputOutput/TextFileReader.h>

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* StreamTokenizerTest::suite(){
	TestSuite* suite = new TestSuite("StreamTokenizerTest");
	suite->addTest(new TestCaller(StreamTokenizerTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {eXg
void StreamTokenizerTest::testBasic(){
	TextFileReader* reader;
	reader = new TextFileReader(
		"Resource/Core/InputOutput/StreamTokenizerTest_testBasic.txt");
	StreamTokenizer* tokenizer = new StreamTokenizer(reader);

	TestAssert(tokenizer->nextToken());
	TestEquals("test0", tokenizer->getToken().getBytes());
	TestEquals(1, tokenizer->getLineNumber());

	TestAssert(tokenizer->nextToken());
	TestEquals("test1", tokenizer->getToken().getBytes());
	TestEquals(1, tokenizer->getLineNumber());

	TestAssert(tokenizer->nextToken());
	TestEquals("test2", tokenizer->getToken().getBytes());
	TestEquals(1, tokenizer->getLineNumber());

	TestAssert(tokenizer->nextToken());
	TestEquals("test3", tokenizer->getToken().getBytes());
	TestEquals(3, tokenizer->getLineNumber());

	TestAssert(!tokenizer->nextToken());
	TestEquals(6, tokenizer->getLineNumber());

	delete tokenizer;
	delete reader;
}
//------------------------------------------------------------------------------
