//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * t@CpXeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/InputOutput/FilePathTest.h"
#include "Core/InputOutput/FilePath.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* FilePathTest::suite(){
	TestSuite* suite = new TestSuite("FilePathTest");
	suite->addTest(new TestCaller(FilePathTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {@\eXg
void FilePathTest::testBasic(){
	FilePath filePath0("D:/Hoge/hoo/bar.txt");
	TestEquals("bar", filePath0.getName());
	TestEquals("bar.txt", filePath0.getFileName());
	TestEquals("txt", filePath0.getExtension());
	TestEquals("D:/Hoge/hoo/", filePath0.getFolderPath());

	FilePath filePath1("D:\\Hoge\\hoo\\bar.txt");
	TestEquals("bar", filePath1.getName());
	TestEquals("bar.txt", filePath1.getFileName());
	TestEquals("txt", filePath1.getExtension());
	TestEquals("D:\\Hoge\\hoo\\", filePath1.getFolderPath());

	FilePath filePath2("hoge.txt");
	TestEquals("hoge", filePath2.getName());
	TestEquals("hoge.txt", filePath2.getFileName());
	TestEquals("txt", filePath2.getExtension());
	TestEquals("", filePath2.getFolderPath());

	FilePath filePath3("hoge");
	TestEquals("hoge", filePath3.getName());
	TestEquals("hoge", filePath3.getFileName());
	TestEquals("", filePath3.getExtension());
	TestEquals("", filePath3.getFolderPath());

	FilePath filePath4("foo/bar");
	TestEquals("bar", filePath4.getName());
	TestEquals("bar", filePath4.getFileName());
	TestEquals("", filePath4.getExtension());
	TestEquals("foo/", filePath4.getFolderPath());
}
//------------------------------------------------------------------------------
