//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * o̓eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/InputOutput/CoreInputOutputAllTests.h"
#include "Core/InputOutput/TextIOTest.h"
#include "Core/InputOutput/BinaryIOTest.h"
#include "Core/InputOutput/StreamTokenizerTest.h"
#include "Core/InputOutput/TextConverterTest.h"
#include "Core/InputOutput/FilePathTest.h"

//------------------------------------------------------------------------------
// RXgN^
CoreInputOutputAllTests::CoreInputOutputAllTests() :
	TestSuite("CoreInputOutputAllTests"){
	// eLXgo̓eXg
	addTest(TextIOTest::suite());
	// oCio̓eXg
	addTest(BinaryIOTest::suite());
	// Xg[g[NiCUeXg
	addTest(StreamTokenizerTest::suite());
	// eLXgRo[^eXg
	addTest(TextConverterTest::suite());
	// t@CpXeXg
	addTest(FilePathTest::suite());
}
//------------------------------------------------------------------------------
