//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCio̓eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/InputOutput/BinaryIOTest.h"
#include <Core/InputOutput/BinaryFileWriter.h>
#include <Core/InputOutput/BinaryFileReader.h>
#include <Core/InputOutput/BinaryMemoryWriter.h>
#include <Core/InputOutput/BinaryMemoryReader.h>

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* BinaryIOTest::suite(){
	TestSuite* suite = new TestSuite("BinaryIOTest");
	suite->addTest(new TestCaller(BinaryIOTest, testFileBasic));
	suite->addTest(new TestCaller(BinaryIOTest, testFileIO));
	suite->addTest(new TestCaller(BinaryIOTest, testMemoryBasic));
	suite->addTest(new TestCaller(BinaryIOTest, testMemoryIO));
	return suite;
}
//------------------------------------------------------------------------------
// t@C{@\eXg
void BinaryIOTest::testFileBasic(){
	// {@\
	BinaryFileWriter* writer = new BinaryFileWriter(
		"Resource/Temporary/BinaryIOTest_testFileIO_0.txt");
	basicWrite(writer);
	delete writer;
	// {@\ǂݍ
	BinaryFileReader* reader = new BinaryFileReader(
		"Resource/Temporary/BinaryIOTest_testFileIO_0.txt");
	basicRead(reader);
	delete reader;
}
//------------------------------------------------------------------------------
// t@Co̓eXg
void BinaryIOTest::testFileIO(){
	// ʏ폑
	BinaryFileWriter* writer = new BinaryFileWriter(
		"Resource/Temporary/BinaryIOTest_testFileIO_1.txt");
	binaryWrite(writer);
	delete writer;
	// ʏǂݍ
	BinaryFileReader* reader = new BinaryFileReader(
		"Resource/Temporary/BinaryIOTest_testFileIO_1.txt");
	binaryRead(reader);
	delete reader;
}
//------------------------------------------------------------------------------
// {@\eXg
void BinaryIOTest::testMemoryBasic(){
	// {@\
	BinaryMemoryWriter* writer =
		new BinaryMemoryWriter(1);
	basicWrite(writer);
	// {@\ǂݍ
	BinaryMemoryReader* reader =
		new BinaryMemoryReader(writer->getBuffer(), writer->getSize());
	basicRead(reader);
	delete reader;
	delete writer;
}
//------------------------------------------------------------------------------
// o̓eXg
void BinaryIOTest::testMemoryIO(){
	// ʏ폑
	BinaryMemoryWriter* writer =
		new BinaryMemoryWriter(1);
	binaryWrite(writer);
	// ʏǂݍ
	BinaryMemoryReader* reader =
		new BinaryMemoryReader(writer->getBuffer(), writer->getSize());
	binaryRead(reader);
	delete reader;
	delete writer;
}
//------------------------------------------------------------------------------
// {
void BinaryIOTest::basicWrite(BinaryWriter* writer){
	int value = 123456;
	writer->writeBytes(&value, sizeof(int));
	writer->skip(2);
	writer->writeBytes(&value, sizeof(int));
	int result = writer->align(4);
	TestEquals(2, result);
	writer->writeBytes(&value, sizeof(int));
	writer->flush();
	result = writer->getPosition();
	TestEquals(16, result);
	writer->setPosition(4);
	result = writer->getPosition();
	TestEquals(4, result);
}
//------------------------------------------------------------------------------
// {ǂݍ
void BinaryIOTest::basicRead(BinaryReader* reader){
	int value, result;
	TestEquals(16, reader->getSize());
	reader->readBytes(&value, sizeof(int));
	TestEquals(123456, value);
	reader->skip(2);
	reader->readBytes(&value, sizeof(int));
	TestEquals(123456, value);
	result = reader->align(4);
	TestEquals(2, result);
	reader->readBytes(&value, sizeof(int));
	TestEquals(123456, value);
	result = reader->getPosition();
	TestEquals(16, result);
	reader->setPosition(4);
	result = reader->getPosition();
	TestEquals(4, result);
	reader->setPosition(16);
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
// oCi
void BinaryIOTest::binaryWrite(BinaryWriter* writer){
	int array[] = {1, 2, 3, 4, 5, 6, 7, 8};
	writer->writeChar(127);
	writer->writeChar(-128);
	writer->writeUChar(0);
	writer->writeUChar(255);
	writer->writeShort(32767);
	writer->writeShort(-32768);
	writer->writeUShort(0);
	writer->writeUShort(65535);
	writer->writeInt(2147483647);
	writer->writeInt(-2147483647 - 1);
	writer->writeUInt(0u);
	writer->writeUInt(4294967295u);
	writer->writeFloat(0.123456f);
	writer->writeDouble(0.1234567890123456);
	writer->writeString("abc\n");
	writer->writeArray(array, sizeof(int), 8);
}
//------------------------------------------------------------------------------
// oCiǂݍ
void BinaryIOTest::binaryRead(BinaryReader* reader){
	int array[] = {0, 0, 0, 0, 0, 0, 0, 0};
	TestEquals(127, reader->readChar());
	TestEquals(-128, reader->readChar());
	TestEquals(0, reader->readUChar());
	TestEquals(255, reader->readUChar());
	TestEquals(32767, reader->readShort());
	TestEquals(-32768, reader->readShort());
	TestEquals(0, reader->readUShort());
	TestEquals(65535, reader->readUShort());
	TestEquals(2147483647, reader->readInt());
	TestEquals(-2147483647 - 1, reader->readInt());
	TestEquals(0u, reader->readUInt());
	TestEquals(4294967295u, reader->readUInt());
	TestEquals(0.123456f, reader->readFloat());
	TestEquals(0.1234567890123456, reader->readDouble());
	TestEquals("abc\n", reader->readString());
	reader->readArray(array, sizeof(int), 8);
	for(int i = 0;i < 8;i++){ TestEquals(i + 1, array[i]); }
	TestAssert(reader->isEnd());
}
//------------------------------------------------------------------------------
