//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * K[̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Debug/LoggerTest.h"
#include "Core/Debug/Logger.h"
#include "Core/InputOutput/TextFileReader.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* LoggerTest::suite(){
	TestSuite* suite = new TestSuite("LoggerTest");
	suite->addTest(new TestCaller(LoggerTest, testFew));
	suite->addTest(new TestCaller(LoggerTest, testMidium));
	suite->addTest(new TestCaller(LoggerTest, testMany));
	return suite;
}
//------------------------------------------------------------------------------
// ŏo̓eXg
void LoggerTest::testFew(){
	Logger* logger = new Logger(
		"Resource/Temporary/LoggerTestFew.txt", Logger::fewLevel);
	logger->output(Logger::fewLevel, "%s\n", "few");
	logger->output(Logger::midiumLevel, "midium\n");
	logger->output(Logger::manyLevel, String("many\n"));
	delete logger;
	TextFileReader* reader = new TextFileReader(
		"Resource/Temporary/LoggerTestFew.txt");
	TestEquals("few", reader->readLine());
	TestAssert(reader->isEnd());
	delete reader;
}
//------------------------------------------------------------------------------
// ʏo̓eXg
void LoggerTest::testMidium(){
	Logger* logger = new Logger(
		"Resource/Temporary/LoggerTestMidium.txt", Logger::midiumLevel);
	logger->output(Logger::fewLevel, "%s\n", "few");
	logger->output(Logger::midiumLevel, "midium\n");
	logger->output(Logger::manyLevel, String("many\n"));
	delete logger;
	TextFileReader* reader = new TextFileReader(
		"Resource/Temporary/LoggerTestMidium.txt");
	TestEquals("few", reader->readLine());
	TestEquals("midium", reader->readLine());
	TestAssert(reader->isEnd());
	delete reader;
}
//------------------------------------------------------------------------------
// őo̓eXg
void LoggerTest::testMany(){
	Logger* logger = new Logger(
		"Resource/Temporary/LoggerTestMany.txt", Logger::manyLevel);
	logger->output(Logger::fewLevel, "%s\n", "few");
	logger->output(Logger::midiumLevel, "midium\n");
	logger->output(Logger::manyLevel, String("many\n"));
	delete logger;
	TextFileReader* reader = new TextFileReader(
		"Resource/Temporary/LoggerTestMany.txt");
	TestEquals("few", reader->readLine());
	TestEquals("midium", reader->readLine());
	TestEquals("many", reader->readLine());
	TestAssert(reader->isEnd());
	delete reader;
}
//------------------------------------------------------------------------------
