//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * SĂCoreeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/CoreAllTests.h"

#include "Core/Debug/CoreDebugAllTests.h"
#include "Core/System/CoreSystemAllTests.h"
#include "Core/Primitive/CorePrimitiveAllTests.h"
#include "Core/Container/CoreContainerAllTests.h"
#include "Core/Thread/CoreThreadAllTests.h"
#include "Core/Utility/CoreUtilityAllTests.h"
#include "Core/InputOutput/CoreInputOutputAllTests.h"
#include "Core/Codec/CoreCodecAllTests.h"

//------------------------------------------------------------------------------
// RXgN^
CoreAllTests::CoreAllTests() : TestSuite("CoreAllTests"){
	// fobOeXg
	addTest(new CoreDebugAllTests());
	// VXeeXg
	addTest(new CoreSystemAllTests());
	// v~eBueXg
	addTest(new CorePrimitiveAllTests());
	// ReieXg
	addTest(new CoreContainerAllTests());
	// XbheXg
	addTest(new CoreThreadAllTests());
	// [eBeBeXg
	addTest(new CoreUtilityAllTests());
	// o̓eXg
	addTest(new CoreInputOutputAllTests());
	// CodeceXg
	addTest(new CoreCodecAllTests());
}
//------------------------------------------------------------------------------
