//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtIuWFNgf[^x[X̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Container/NamedObjectDatabaseTest.h"
#include "Core/Container/NamedObjectDatabase.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* NamedObjectDatabaseTest::suite(){
	TestSuite* suite = new TestSuite("NamedObjectDatabaseTest");
	suite->addTest(new TestCaller(NamedObjectDatabaseTest, testBasic));
	return suite;
}
//------------------------------------------------------------------------------
// {eXg
void NamedObjectDatabaseTest::testBasic(){
	// ACe
	int itemSize = 3072;
	String* items = new String[itemSize];
	char table[] = {
		'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
		'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
		'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
		'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '_'};
	for(int i = 0;i < itemSize;i++){
		items[i].format("%c%c%c%c%c%c%c",
			table[rand() % 63], table[rand() % 63],
			table[rand() % 63], table[rand() % 63],
			table[rand() % 63], table[rand() % 63],
			table[rand() % 63], table[rand() % 63]);
	}

	NamedObjectDatabase<String> database(1, 0.75f);
	TestAssert(database.getCount() == 0);
	for(int i = 0; i < itemSize; i++){
		TestAssert(database.add(items[i], &items[i]));
	}

	// 擾
	TestEquals(itemSize, database.getCount());
	for(int i = 0;i < itemSize;i++){
		TestEquals(items[i], *database.get(i));
	}

	// 
	for(int i = 0;i < itemSize;i++){
		TestEquals(items[i], *database.search(items[i]));
	}

	itemSize /= 2;

	// 폜
	for(int i = 0;i < itemSize;i++){
		int index = i * 2 + 1;
		TestAssert(database.remove(items[index], &items[index]));
	}

	// 擾
	TestEquals(itemSize, database.getCount());
	for(int i = 0;i < itemSize;i++){
		TestEquals(items[i * 2], *database.get(i));
	}

	// 
	for(int i = 0;i < itemSize;i++){
		TestEquals(items[i * 2], *database.search(items[i * 2]));
	}

	TestAssert(database.clear() == itemSize);
	// n
	delete[] items;
}
//------------------------------------------------------------------------------
