//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ACXg̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include <Core/Container/ArrayList.h>
#include "Core/Container/ArrayListTest.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* ArrayListTest::suite(){
	TestSuite* suite = new TestSuite("ArrayListTest");
	suite->addTest(new TestCaller(ArrayListTest, testIntArray));
	suite->addTest(new TestCaller(ArrayListTest, testFloatArray));
	suite->addTest(new TestCaller(ArrayListTest, testPointerArray));
	suite->addTest(new TestCaller(ArrayListTest, testSort));
	return suite;
}
//------------------------------------------------------------------------------
// intACeXg
void ArrayListTest::testIntArray(){
	typedef ArrayList<int> IntArray;
	IntArray intArray(2);
	TestAssert(intArray.isEmpty());
	TestEquals(0, intArray.getCount());
	TestEquals(2, intArray.getCapacity());
	intArray.trim();
	TestEquals(0, intArray.getCount());
	TestEquals(1, intArray.getCapacity());
	for(int i = 0; i < 7; i++){ intArray.add(i); }
	TestAssert(!intArray.isEmpty());
	TestEquals(7, intArray.getCount());
	TestEquals(8, intArray.getCapacity());
	intArray.add(7);
	TestEquals(8, intArray.getCount());
	TestEquals(8, intArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals(i, intArray.get(i)); }
	intArray.setCapacity(8);
	TestEquals(8, intArray.getCount());
	TestEquals(8, intArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals(i, intArray.get(i)); }
	intArray.setCapacity(16);
	TestEquals(8, intArray.getCount());
	TestEquals(16, intArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals(i, intArray.get(i)); }
	IntArray cloneArray;
	intArray.clone(cloneArray);
	TestEquals(8, cloneArray.getCount());
	TestEquals(16, cloneArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals(i, cloneArray.get(i)); }
	cloneArray.clear();
	TestEquals(0, cloneArray.getCount());
	TestEquals(16, cloneArray.getCapacity());
	intArray.trim();
	TestEquals(8, intArray.getCount());
	TestEquals(8, intArray.getCapacity());
	for(int i = 0; i < 8; i++){
		TestEquals(i, intArray.indexOf(i));
		TestEquals(i, intArray.lastIndexOf(i));
	}
	for(int i = 7; i >= 4; i--){ TestEquals(i, intArray.remove(i)); }
	TestEquals(4, intArray.getCount());
	TestEquals(8, intArray.getCapacity());
	for(int i = 0; i < 4; i++){ TestEquals(i, intArray.get(i)); }
	for(int i = 0; i < 4; i++){ TestEquals(0, intArray.removeByValue(i)); }
	TestEquals(0, intArray.getCount());
	TestEquals(8, intArray.getCapacity());
	intArray.add(0);
	intArray[0] = 1;
	TestEquals(1, intArray[0]);
	intArray.set(0, 2);
	TestEquals(2, intArray[0]);

}
//------------------------------------------------------------------------------
// floatACeXg
void ArrayListTest::testFloatArray(){
	typedef ArrayList<float> FloatArray;
	FloatArray floatArray(2);
	TestAssert(floatArray.isEmpty());
	TestEquals(0, floatArray.getCount());
	TestEquals(2, floatArray.getCapacity());
	floatArray.trim();
	TestEquals(0, floatArray.getCount());
	TestEquals(1, floatArray.getCapacity());
	for(int i = 0; i < 7; i++){ floatArray.add((float)i); }
	TestAssert(!floatArray.isEmpty());
	TestEquals(7, floatArray.getCount());
	TestEquals(8, floatArray.getCapacity());
	floatArray.add(7);
	TestEquals(8, floatArray.getCount());
	TestEquals(8, floatArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals((float)i, floatArray.get(i)); }
	floatArray.setCapacity(8);
	TestEquals(8, floatArray.getCount());
	TestEquals(8, floatArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals((float)i, floatArray.get(i)); }
	floatArray.setCapacity(16);
	TestEquals(8, floatArray.getCount());
	TestEquals(16, floatArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals((float)i, floatArray.get(i)); }
	FloatArray cloneArray;
	floatArray.clone(cloneArray);
	TestEquals(8, cloneArray.getCount());
	TestEquals(16, cloneArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestEquals((float)i, cloneArray.get(i)); }
	cloneArray.clear();
	TestEquals(0, cloneArray.getCount());
	TestEquals(16, cloneArray.getCapacity());
	floatArray.trim();
	TestEquals(8, floatArray.getCount());
	TestEquals(8, floatArray.getCapacity());
	for(int i = 0; i < 8; i++){
		TestEquals(i, floatArray.indexOf((float)i));
		TestEquals(i, floatArray.lastIndexOf((float)i));
	}
	for(int i = 7; i >= 4; i--){ TestEquals((float)i, floatArray.remove(i)); }
	TestEquals(4, floatArray.getCount());
	TestEquals(8, floatArray.getCapacity());
	for(int i = 0; i < 4; i++){ TestEquals((float)i, floatArray.get(i)); }
	for(int i = 0; i < 4; i++){
		TestEquals(0, floatArray.removeByValue((float)i));
	}
	TestEquals(0, floatArray.getCount());
	TestEquals(8, floatArray.getCapacity());
}
//------------------------------------------------------------------------------
// |C^ACeXg
void ArrayListTest::testPointerArray(){
	typedef ArrayList<int*> PointerArray;
	PointerArray pointerArray(2);
	TestAssert(pointerArray.isEmpty());
	TestEquals(0, pointerArray.getCount());
	TestEquals(2, pointerArray.getCapacity());
	pointerArray.trim();
	TestEquals(0, pointerArray.getCount());
	TestEquals(1, pointerArray.getCapacity());
	int* array[8];
	for(int i = 0; i < 8; i++){
		array[i] = new int();
		pointerArray.add(array[i]);
	}
	TestAssert(!pointerArray.isEmpty());
	TestEquals(8, pointerArray.getCount());
	TestEquals(8, pointerArray.getCapacity());
	pointerArray.setCapacity(16);
	TestEquals(8, pointerArray.getCount());
	TestEquals(16, pointerArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestAssert((array[i] == pointerArray.get(i))); }
	PointerArray cloneArray;
	pointerArray.clone(cloneArray);
	TestEquals(8, cloneArray.getCount());
	TestEquals(16, cloneArray.getCapacity());
	for(int i = 0; i < 8; i++){ TestAssert((array[i] == cloneArray.get(i))); }
	cloneArray.clear();
	TestEquals(0, cloneArray.getCount());
	TestEquals(16, cloneArray.getCapacity());
	pointerArray.trim();
	TestEquals(8, pointerArray.getCount());
	TestEquals(8, pointerArray.getCapacity());
	for(int i = 0; i < 8; i++){
		TestEquals(i, pointerArray.indexOf(array[i]));
		TestEquals(i, pointerArray.lastIndexOf(array[i]));
	}
	for(int i = 7; i >= 4; i--){ TestAssert(array[i] == pointerArray.remove(i)); }
	TestEquals(4, pointerArray.getCount());
	TestEquals(8, pointerArray.getCapacity());
	for(int i = 0; i < 4; i++){ TestAssert(array[i] == pointerArray.get(i)); }
	for(int i = 0; i < 4; i++){ TestEquals(0, pointerArray.removeByValue(array[i])); }
	TestEquals(0, pointerArray.getCount());
	TestEquals(8, pointerArray.getCapacity());
	for(int i = 0; i < 8; i++){ delete array[i]; }
}
//------------------------------------------------------------------------------
// \[geXg
void ArrayListTest::testSort(){
	typedef ArrayList<int> IntArray;
	int size = 16;
	IntArray intArray(size);
	for(int i = 0; i < size; i++){
		intArray.add(size - i - 1);
	}
	intArray.sort(compareInt);
	for(int i = 0; i < size; i++){
		TestEquals(i, intArray[i]);
	}
	for(int i = 0; i < size; i++){
		int* result = intArray.search(i, compareInt);
		TestEquals(i, *result);
	}
}
//------------------------------------------------------------------------------
// Int̔r
int ArrayListTest::compareInt(const int* left, const int* right){
	return (*left) - (*right);
}
//------------------------------------------------------------------------------
