//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TargãeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Core/Codec/TargaTest.h"
#include "Core/Codec/Tga/TargaLoader.h"
#include "Core/Codec/Tga/TargaSaver.h"
#include "Core/InputOutput/BinaryFileReader.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* TargaTest::suite(){
	TestSuite* suite = new TestSuite("TargaTest");
	suite->addTest(new TestCaller(TargaTest, testLoad));
	suite->addTest(new TestCaller(TargaTest, testSave));
	return suite;
}
//------------------------------------------------------------------------------
// ǂݍ݃eXg
void TargaTest::testLoad(){
	// At@
	TargaLoader loader0("Resource/Core/Codec/Tga/RGB.tga");
	loader0.loadHeader();
	TestEquals(2, loader0.getWidth());
	TestEquals(2, loader0.getHeight());
	TestAssert(!loader0.hasAlpha());
	Color3c buffer0[4];
	loader0.loadImage(buffer0);
	TestAssert(Color3c(64, 0, 0) == buffer0[0]);
	TestAssert(Color3c(128, 0, 0) == buffer0[1]);
	TestAssert(Color3c(192, 0, 0) == buffer0[2]);
	TestAssert(Color3c(0, 0, 255) == buffer0[3]);

	TargaLoader loader1("Resource/Core/Codec/Tga/RGB.tga");
	loader1.loadHeader();
	Color4c buffer1[4];
	loader1.loadImage(buffer1);
	TestAssert(Color4c(64, 0, 0, 255) == buffer1[0]);
	TestAssert(Color4c(128, 0, 0, 255) == buffer1[1]);
	TestAssert(Color4c(192, 0, 0, 255) == buffer1[2]);
	TestAssert(Color4c(0, 0, 255, 255) == buffer1[3]);

	// At@L
	TargaLoader loader2("Resource/Core/Codec/Tga/RGBA.tga");
	loader2.loadHeader();
	TestEquals(2, loader2.getWidth());
	TestEquals(2, loader2.getHeight());
	TestAssert(loader2.hasAlpha());
	Color4c buffer2[4];
	loader2.loadImage(buffer2);
	TestAssert(Color4c(64, 0, 0, 126) == buffer2[0]);
	TestAssert(Color4c(128, 0, 0, 126) == buffer2[1]);
	TestAssert(Color4c(192, 0, 0, 126) == buffer2[2]);
	TestAssert(Color4c(0, 0, 255, 126) == buffer2[3]);

	TargaLoader loader3("Resource/Core/Codec/Tga/RGBA.tga");
	loader3.loadHeader();
	Color3c buffer3[4];
	loader3.loadImage(buffer3);
	TestAssert(Color3c(64, 0, 0) == buffer3[0]);
	TestAssert(Color3c(128, 0, 0) == buffer3[1]);
	TestAssert(Color3c(192, 0, 0) == buffer3[2]);
	TestAssert(Color3c(0, 0, 255) == buffer3[3]);
}
//------------------------------------------------------------------------------
// oeXg
void TargaTest::testSave(){
	TargaSaver saver;
	Color3c buffer0[4] = {
		Color3c(64, 0, 0),
		Color3c(128, 0, 0),
		Color3c(192, 0, 0),
		Color3c(0, 0, 255) };
	saver.save("Resource/Temporary/TargaTest_testSaveRGB.tga", 2, 2, buffer0);
	BinaryFileReader* reader0 =
		new BinaryFileReader("Resource/Core/Codec/Tga/RGB.tga");
	BinaryFileReader* reader1 =
		new BinaryFileReader("Resource/Temporary/TargaTest_testSaveRGB.tga");
	int size0 = reader0->getSize();
	TestEquals(size0, reader1->getSize());
	for(int i = 0; i < size0; i++){
		TestEquals(reader0->readChar(), reader1->readChar());
	}
	delete reader1;
	delete reader0;

	Color4c buffer1[4] = {
		Color4c(64, 0, 0, 126),
		Color4c(128, 0, 0, 126),
		Color4c(192, 0, 0, 126),
		Color4c(0, 0, 255, 126) };
	saver.save("Resource/Temporary/TargaTest_testSaveRGBA.tga", 2, 2, buffer1);
	BinaryFileReader* reader2 =
		new BinaryFileReader("Resource/Core/Codec/Tga/RGBA.tga");
	BinaryFileReader* reader3 =
		new BinaryFileReader("Resource/Temporary/TargaTest_testSaveRGBA.tga");
	int size1 = reader2->getSize();
	TestEquals(size1, reader3->getSize());
	for(int i = 0; i < size1; i++){
		TestEquals(reader2->readChar(), reader3->readChar());
	}
	delete reader3;
	delete reader2;
}
//------------------------------------------------------------------------------
