//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWV[eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Collision/System/CollisionSceneTest.h"
#include "Collision/System/CollisionScene.h"
#include "Collision/System/CollisionNode.h"
#include "Collision/Leaf/StaticDeformedMeshCollision.h"

//------------------------------------------------------------------------------
// RXgN^
CollisionSceneTest::CollisionSceneTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* CollisionSceneTest::suite(){
	TestSuite* suite = new TestSuite("CollisionSceneTest");
	suite->addTest(new TestCaller(CollisionSceneTest, testConstructor));
	suite->addTest(new TestCaller(CollisionSceneTest, testNodeDatabase));
	suite->addTest(new TestCaller(CollisionSceneTest, testLeafDatabase));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void CollisionSceneTest::testConstructor(){
	CollisionScene* scene0 = new CollisionScene();
	TestEquals(0, scene0->clear());
	TestAssert(scene0->getRootNode() != NULL);
	TestAssert(scene0->getRootNode()->getName() == "RootNode");
	TestAssert(scene0->existNodeName("RootNode"));
	TestAssert(!scene0->existLeafName("RootNode"));
	TestAssert(scene0->renameNode("RootNode") == "RootNode_0");
	delete scene0;

	CollisionScene scene1;
	TestEquals(0, scene1.clear());
}
//------------------------------------------------------------------------------
// m[hf[^x[XeXg
void CollisionSceneTest::testNodeDatabase(){
	CollisionScene* scene = new CollisionScene();
	// f[^x[X̍\z
	int collisionNodeCount = 257;
	String* names = new String[collisionNodeCount];
	CollisionNode** collisionNodes = new CollisionNode*[collisionNodeCount];
	for(int i = 0; i < collisionNodeCount; i++){
		names[i].format("collisionNode%d", i);
	}
	for(int i = 0; i < collisionNodeCount; i++){
		collisionNodes[i] = scene->createCollisionNode(names[i]);
	}
	// zANZX
	TestEquals(collisionNodeCount + 1, scene->getNodeCount());
	for(int i = 0; i < collisionNodeCount; i++){
		TestEquals(names[i], scene->getNode(i + 1)->getName());
		TestAssert(collisionNodes[i] == scene->getNode(i + 1));
	}
	// ANZX
	for(int i = 0; i < collisionNodeCount; i++){
		CollisionNode* collisionNode =
			scene->searchNode(names[i]);
		TestAssert(collisionNode == scene->getNode(i + 1));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		scene->destroyNode(collisionNodes[i]);
	}
	// NA
	TestEquals(collisionNodeCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] collisionNodes;
	delete[] names;
	delete scene;
}
//------------------------------------------------------------------------------
// [tf[^x[XeXg
void CollisionSceneTest::testLeafDatabase(){
	CollisionScene* scene = new CollisionScene();
	// f[^x[X̍\z
	int collisionLeafCount = 257;
	String* names = new String[collisionLeafCount];
	CollisionLeaf** collisionLeafs = new CollisionLeaf*[collisionLeafCount];
	for(int i = 0; i < collisionLeafCount; i++){
		names[i].format("collisionLeaf%d", i);
	}
	for(int i = 0; i < collisionLeafCount; i++){
		collisionLeafs[i] = scene->createStaticDeformedMeshCollision(names[i]);
	}
	// zANZX
	TestEquals(collisionLeafCount, scene->getLeafCount());
	for(int i = 0; i < collisionLeafCount; i++){
		TestEquals(names[i], scene->getLeaf(i)->getName());
		TestAssert(collisionLeafs[i] == scene->getLeaf(i));
	}
	// ANZX
	for(int i = 0; i < collisionLeafCount; i++){
		CollisionLeaf* collisionLeaf =
			scene->searchLeaf(names[i]);
		TestAssert(collisionLeaf == scene->getLeaf(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		scene->destroyLeaf(collisionLeafs[i]);
	}
	// NA
	TestEquals(collisionLeafCount - destroyCount, scene->clear());
	TestEquals(0, scene->clear());
	delete[] collisionLeafs;
	delete[] names;
	delete scene;
}
//------------------------------------------------------------------------------
