//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWm[heXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Collision/System/CollisionNodeTest.h"
#include "Collision/System/CollisionScene.h"
#include "Collision/System/CollisionNode.h"
#include "Collision/Leaf/StaticDeformedMeshCollision.h"

//------------------------------------------------------------------------------
// RXgN^
CollisionNodeTest::CollisionNodeTest(String name) : TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* CollisionNodeTest::suite(){
	TestSuite* suite = new TestSuite("CollisionNodeTest");
	suite->addTest(new TestCaller(CollisionNodeTest, testData));
	suite->addTest(new TestCaller(CollisionNodeTest, testCopy));
	suite->addTest(new TestCaller(CollisionNodeTest, testTraverse));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void CollisionNodeTest::testData(){
	CollisionScene scene;
	CollisionNode* node0 = scene.createCollisionNode("node0");
	TestAssert(node0->isCollisionNode());
	// RWIuWFNg
	TestAssert(node0->getName() == "node0");
	TestAssert(node0->getScene() == (&scene));
	TestAssert(node0->getParent() == NULL);
	scene.getRootNode()->addChild(node0);
	TestAssert(node0->getParent() == scene.getRootNode());
	TestAssert(node0->isEnabled());
	node0->setEnabled(false);
	TestAssert(!node0->isEnabled());
	TestAssert(node0->isGlobalEnabled());

	// RWm[h
	TestEquals(1, scene.getRootNode()->getChildCount());
	TestAssert(scene.getRootNode()->getChild(0) == node0);
	// XP[
	TestAssert(Vector3(1.f, 1.f, 1.f) == node0->getScale());
	TestAssert(!node0->isScaled());
	node0->setScale(Vector3(0.f, 0.f, 0.f));
	TestAssert(Vector3(0.f, 0.f, 0.f) == node0->getScale());
	TestAssert(node0->isScaled());
	// ]
	TestAssert(Vector3(0.f, 0.f, 0.f) == node0->getRotationXYZ());
	TestAssert(Quaternion(0.f, 0.f, 0.f, 1.f) ==
		node0->getRotationQuaternion());
	node0->setRotationXYZ(Vector3(1.f, 0.f, 0.f));
	TestAssert(Vector3(1.f, 0.f, 0.f) == node0->getRotationXYZ());
	TestAssert(Quaternion(0.47942555f, 0.f, 0.f, 0.87758255f) ==
		node0->getRotationQuaternion());
	// ړ
	TestAssert(Vector3(0.f, 0.f, 0.f) == node0->getTranslation());
	node0->setTranslation(Vector3(1.f, 1.f, 1.f));
	TestAssert(Vector3(1.f, 1.f, 1.f) == node0->getTranslation());

	scene.getRootNode()->removeChild(node0);
	TestAssert(node0->getParent() == NULL);

	scene.destroyNode(node0);
	TestEquals(0, scene.clear());
}
//------------------------------------------------------------------------------
// Rs[eXg
void CollisionNodeTest::testCopy(){
	CollisionScene scene;
	CollisionNode* node0 = scene.createCollisionNode("node0");
	CollisionNode* node1 = scene.createCollisionNode("node1");
	StaticDeformedMeshCollision* mesh0 = scene.createStaticDeformedMeshCollision("mesh0");
	scene.getRootNode()->addChild(node0);
	TestAssert(node0->getParent() == scene.getRootNode());
	node0->setEnabled(false);

	node0->addChild(node1);
	node0->addChild(mesh0);

	node0->setScale(Vector3(0.f, 0.f, 0.f));
	node0->setRotationXYZ(Vector3(1.f, 0.f, 0.f));
	node0->setTranslation(Vector3(1.f, 1.f, 1.f));

	CollisionNode* copyNode = node0->copyCollisionNode();
	TestAssert(copyNode->getName() == "node0_0");
	TestAssert(copyNode->getScene() == (&scene));
	TestAssert(copyNode->getParent() == NULL);
	TestAssert(!copyNode->isEnabled());
	TestAssert(copyNode->isGlobalEnabled());
	TestAssert(Vector3(0.f, 0.f, 0.f) == copyNode->getScale());
	TestAssert(Vector3(1.f, 0.f, 0.f) == copyNode->getRotationXYZ());
	TestAssert(Vector3(1.f, 1.f, 1.f) == copyNode->getTranslation());

	TestEquals(2, copyNode->getChildCount());
	TestAssert(copyNode->getChild(0)->getName() == "node1_0");
	TestAssert(copyNode->getChild(1)->getName() == "mesh0_0");

	TestEquals(2, CollisionNode::recursiveDestroyChildren(node0));
	TestEquals(1, CollisionNode::recursiveDestroy(node0));
	TestEquals(3, CollisionObject::recursiveDestroy(copyNode));
	TestEquals(0, scene.clear());
}
//------------------------------------------------------------------------------
// go[XeXg
void CollisionNodeTest::testTraverse(){
	CollisionScene scene;
	CollisionNode* node0 = scene.createCollisionNode("node0");
	scene.getRootNode()->addChild(node0);

	// O[oύXtO
	scene.traverse();
	TestAssert(node0->isGlobalChanged());
	scene.traverse();
	TestAssert(!node0->isGlobalChanged());

	// O[oLtO
	TestAssert(node0->isGlobalEnabled());
	scene.getRootNode()->setEnabled(false);
	scene.traverse();
	TestAssert(!node0->isGlobalEnabled());
	scene.getRootNode()->setEnabled(true);

	// O[oXP[tO
	scene.getRootNode()->setScale(Vector3(1.f, 2.f, 3.f));
	scene.traverse();
	TestAssert(node0->isGlobalScaled());
	scene.getRootNode()->setScale(Vector3(1.f, 1.f, 1.f));
	scene.traverse();
	TestAssert(!node0->isGlobalScaled());
	TestAssert(node0->isGlobalChanged());
	node0->setScale(Vector3(1.f, 2.f, 3.f));
	scene.traverse();
	TestAssert(node0->isGlobalScaled());
	TestAssert(node0->isGlobalChanged());
	node0->setScale(Vector3(1.f, 1.f, 1.f));

	// s
	scene.getRootNode()->setScale(Vector3(1.f, 2.f, 3.f));
	node0->setTranslation(Vector3(1.f, 1.f, 1.f));
	scene.traverse();
	TestAssert(node0->getLocalMatrix() ==
		Matrix34(1.f, 0.f, 0.f, 1.f, 0.f, 1.f, 0.f, 1.f, 0.f, 0.f, 1.f, 1.f));
	TestAssert(node0->getWorldMatrix() ==
		Matrix34(1.f, 0.f, 0.f, 1.f, 0.f, 2.f, 0.f, 2.f, 0.f, 0.f, 3.f, 3.f));

	TestEquals(1, scene.clear());
}
//------------------------------------------------------------------------------
