//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓIRWeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Collision/Leaf/StaticSphereCollisionTest.h"
#include "Collision/Leaf/StaticSphereCollision.h"
#include "Collision/System/CollisionScene.h"
#include "Collision/System/CollisionNode.h"

//------------------------------------------------------------------------------
// RXgN^
StaticSphereCollisionTest::StaticSphereCollisionTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* StaticSphereCollisionTest::suite(){
	TestSuite* suite = new TestSuite("StaticSphereCollisionTest");
	suite->addTest(new TestCaller(StaticSphereCollisionTest, testData));
	suite->addTest(new TestCaller(StaticSphereCollisionTest, testCopy));
	suite->addTest(new TestCaller(StaticSphereCollisionTest, testTraverse));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void StaticSphereCollisionTest::testData(){
	CollisionScene scene;
	StaticSphereCollision* sphere0 =
		scene.createStaticSphereCollision("sphere0");
	TestAssert(sphere0->isCollisionLeaf());
	TestAssert(sphere0->isStaticCollisionLeaf());
	TestAssert(sphere0->isStaticSphereCollision());

	// RWIuWFNg
	TestAssert(sphere0->getName() == "sphere0");
	TestAssert(sphere0->getScene() == (&scene));
	TestAssert(sphere0->getParent() == NULL);
	scene.getRootNode()->addChild(sphere0);
	TestAssert(sphere0->getParent() == scene.getRootNode());
	TestAssert(sphere0->isEnabled());
	sphere0->setEnabled(false);
	TestAssert(!sphere0->isEnabled());
	TestAssert(!sphere0->isGlobalEnabled());

	// XP[
	TestAssert(Vector3(1.f, 1.f, 1.f) == sphere0->getScale());
	TestAssert(!sphere0->isScaled());
	sphere0->setScale(Vector3(0.f, 0.f, 0.f));
	TestAssert(Vector3(0.f, 0.f, 0.f) == sphere0->getScale());
	TestAssert(sphere0->isScaled());
	// ]
	TestAssert(Vector3(0.f, 0.f, 0.f) == sphere0->getRotationXYZ());
	TestAssert(Quaternion(0.f, 0.f, 0.f, 1.f) ==
		sphere0->getRotationQuaternion());
	sphere0->setRotationXYZ(Vector3(1.f, 0.f, 0.f));
	TestAssert(Vector3(1.f, 0.f, 0.f) == sphere0->getRotationXYZ());
	TestAssert(Quaternion(0.47942555f, 0.f, 0.f, 0.87758255f) ==
		sphere0->getRotationQuaternion());
	// ړ
	TestAssert(Vector3(0.f, 0.f, 0.f) == sphere0->getTranslation());
	sphere0->setTranslation(Vector3(1.f, 1.f, 1.f));
	TestAssert(Vector3(1.f, 1.f, 1.f) == sphere0->getTranslation());

	// 
	TestAssert(Sphere::zero == sphere0->getSphere());
	sphere0->setSphere(Sphere::unit);
	TestAssert(Sphere::unit == sphere0->getSphere());

	// n
	scene.getRootNode()->removeChild(sphere0);
	TestAssert(sphere0->getParent() == NULL);
	scene.destroyLeaf(sphere0);
	TestEquals(0, scene.clear());
}
//------------------------------------------------------------------------------
// Rs[eXg
void StaticSphereCollisionTest::testCopy(){
	CollisionScene scene;
	StaticSphereCollision* sphere0 =
		scene.createStaticSphereCollision("sphere0");
	scene.getRootNode()->addChild(sphere0);
	TestAssert(sphere0->getParent() == scene.getRootNode());
	sphere0->setEnabled(false);
	sphere0->setSphere(Sphere::unit);

	StaticSphereCollision* copySphere = sphere0->copyStaticSphereCollision();
	TestAssert(copySphere->getName() == "sphere0_0");
	TestAssert(copySphere->getScene() == (&scene));
	TestAssert(copySphere->getParent() == NULL);
	TestAssert(!copySphere->isEnabled());
	TestAssert(!copySphere->isGlobalEnabled());
	TestAssert(Sphere::unit == copySphere->getSphere());

	TestEquals(2, scene.clear());
}
//------------------------------------------------------------------------------
// go[XeXg
void StaticSphereCollisionTest::testTraverse(){
	CollisionScene scene;
	StaticSphereCollision* sphere0 =
		scene.createStaticSphereCollision("sphere0");
	scene.getRootNode()->addChild(sphere0);

	// O[oύXtO
	scene.traverse();
	TestAssert(sphere0->isGlobalChanged());
	scene.traverse();
	TestAssert(!sphere0->isGlobalChanged());

	// O[oLtO
	TestAssert(sphere0->isGlobalEnabled());
	scene.getRootNode()->setEnabled(false);
	scene.traverse();
	TestAssert(!sphere0->isGlobalEnabled());
	scene.getRootNode()->setEnabled(true);

	// O[oXP[tO
	scene.getRootNode()->setScale(Vector3(1.f, 2.f, 3.f));
	scene.traverse();
	TestAssert(sphere0->isGlobalScaled());
	scene.getRootNode()->setScale(Vector3(1.f, 1.f, 1.f));
	scene.traverse();
	TestAssert(!sphere0->isGlobalScaled());
	TestAssert(sphere0->isGlobalChanged());
	scene.traverse();
	TestAssert(!sphere0->isGlobalChanged());

	sphere0->setSphere(Sphere::unit);
	scene.getRootNode()->setScale(Vector3(1.f, 2.f, 1.f));
	scene.getRootNode()->setRotationXYZ(Vector3(Math::halfPI, 0.f, 0.f));
	scene.getRootNode()->setTranslation(Vector3(0.f, 1.f, 0.f));
	scene.traverse();
	TestAssert(sphere0->getWorldSphere().epsilonEquals(
		Sphere(0.f, 1.f, 0.f, 2.f), Math::epsilon));

	TestEquals(1, scene.clear());
}
//------------------------------------------------------------------------------
