//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓIό`bVRWeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Collision/Leaf/StaticDeformedMeshCollisionTest.h"
#include "Collision/Leaf/StaticDeformedMeshCollision.h"
#include "Collision/System/CollisionScene.h"
#include "Collision/System/CollisionNode.h"

//------------------------------------------------------------------------------
// RXgN^
StaticDeformedMeshCollisionTest::StaticDeformedMeshCollisionTest(String name) :
	TestCase(name){
}
//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* StaticDeformedMeshCollisionTest::suite(){
	TestSuite* suite = new TestSuite("StaticDeformedMeshCollisionTest");
	suite->addTest(new TestCaller(StaticDeformedMeshCollisionTest, testData));
	suite->addTest(new TestCaller(StaticDeformedMeshCollisionTest, testCopy));
	suite->addTest(new TestCaller(StaticDeformedMeshCollisionTest, testTraverse));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void StaticDeformedMeshCollisionTest::testData(){
	CollisionScene scene;
	StaticDeformedMeshCollision* mesh0 =
		scene.createStaticDeformedMeshCollision("mesh0");
	TestAssert(mesh0->isCollisionLeaf());
	TestAssert(mesh0->isStaticCollisionLeaf());
	TestAssert(mesh0->isStaticDeformedMeshCollision());
	// RWIuWFNg
	TestAssert(mesh0->getName() == "mesh0");
	TestAssert(mesh0->getScene() == (&scene));
	TestAssert(mesh0->getParent() == NULL);
	scene.getRootNode()->addChild(mesh0);
	TestAssert(mesh0->getParent() == scene.getRootNode());
	TestAssert(mesh0->isEnabled());
	mesh0->setEnabled(false);
	TestAssert(!mesh0->isEnabled());
	TestAssert(!mesh0->isGlobalEnabled());

	// XP[
	TestAssert(Vector3(1.f, 1.f, 1.f) == mesh0->getScale());
	TestAssert(!mesh0->isScaled());
	mesh0->setScale(Vector3(0.f, 0.f, 0.f));
	TestAssert(Vector3(0.f, 0.f, 0.f) == mesh0->getScale());
	TestAssert(mesh0->isScaled());
	// ]
	TestAssert(Vector3(0.f, 0.f, 0.f) == mesh0->getRotationXYZ());
	TestAssert(Quaternion(0.f, 0.f, 0.f, 1.f) ==
		mesh0->getRotationQuaternion());
	mesh0->setRotationXYZ(Vector3(1.f, 0.f, 0.f));
	TestAssert(Vector3(1.f, 0.f, 0.f) == mesh0->getRotationXYZ());
	TestAssert(Quaternion(0.47942555f, 0.f, 0.f, 0.87758255f) ==
		mesh0->getRotationQuaternion());
	// ړ
	TestAssert(Vector3(0.f, 0.f, 0.f) == mesh0->getTranslation());
	mesh0->setTranslation(Vector3(1.f, 1.f, 1.f));
	TestAssert(Vector3(1.f, 1.f, 1.f) == mesh0->getTranslation());

	// oEfBO
	TestAssert(AxisAlignedBox::zero == mesh0->getBoundingBox());
	mesh0->setBoundingBox(AxisAlignedBox::unit);
	TestAssert(AxisAlignedBox::unit == mesh0->getBoundingBox());
	TestAssert(Sphere::zero == mesh0->getBoundingSphere());
	mesh0->setBoundingSphere(Sphere::unit);
	TestAssert(Sphere::unit == mesh0->getBoundingSphere());

	// bV
	TestEquals(0, mesh0->getTriangleCount());
	mesh0->setTriangleCount(1);
	TestEquals(1, mesh0->getTriangleCount());
	Triangle triangle(0.f, 1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f);
	mesh0->setTriangle(0, triangle);
	TestAssert(mesh0->getTriangle(0) == triangle);

	// n
	scene.getRootNode()->removeChild(mesh0);
	TestAssert(mesh0->getParent() == NULL);
	scene.destroyLeaf(mesh0);
	TestEquals(0, scene.clear());
}
//------------------------------------------------------------------------------
// Rs[eXg
void StaticDeformedMeshCollisionTest::testCopy(){
	CollisionScene scene;
	StaticDeformedMeshCollision* mesh0 =
		scene.createStaticDeformedMeshCollision("mesh0");
	scene.getRootNode()->addChild(mesh0);
	TestAssert(mesh0->getParent() == scene.getRootNode());
	mesh0->setEnabled(false);
	mesh0->setBoundingBox(AxisAlignedBox::unit);
	mesh0->setBoundingSphere(Sphere::unit);
	mesh0->setTriangleCount(1);
	Triangle triangle(0.f, 1.f, 2.f, 3.f, 4.f, 5.f, 6.f, 7.f, 8.f);
	mesh0->setTriangle(0, triangle);

	StaticDeformedMeshCollision* copyMesh =
		mesh0->copyStaticDeformedMeshCollision();
	TestAssert(copyMesh->getName() == "mesh0_0");
	TestAssert(copyMesh->getScene() == (&scene));
	TestAssert(copyMesh->getParent() == NULL);
	TestAssert(!copyMesh->isEnabled());
	TestAssert(!copyMesh->isGlobalEnabled());
	TestAssert(AxisAlignedBox::unit == copyMesh->getBoundingBox());
	TestAssert(Sphere::unit == copyMesh->getBoundingSphere());
	TestEquals(1, copyMesh->getTriangleCount());
	TestAssert(copyMesh->getTriangle(0) == triangle);

	TestEquals(2, scene.clear());
}
//------------------------------------------------------------------------------
// go[XeXg
void StaticDeformedMeshCollisionTest::testTraverse(){
	CollisionScene scene;
	StaticDeformedMeshCollision* mesh0 =
		scene.createStaticDeformedMeshCollision("mesh0");
	scene.getRootNode()->addChild(mesh0);

	// O[oύXtO
	scene.traverse();
	TestAssert(mesh0->isGlobalChanged());
	scene.traverse();
	TestAssert(!mesh0->isGlobalChanged());

	// O[oLtO
	TestAssert(mesh0->isGlobalEnabled());
	scene.getRootNode()->setEnabled(false);
	scene.traverse();
	TestAssert(!mesh0->isGlobalEnabled());
	scene.getRootNode()->setEnabled(true);

	// O[oXP[tO
	scene.getRootNode()->setScale(Vector3(1.f, 2.f, 3.f));
	scene.traverse();
	TestAssert(mesh0->isGlobalScaled());
	scene.getRootNode()->setScale(Vector3(1.f, 1.f, 1.f));
	scene.traverse();
	TestAssert(!mesh0->isGlobalScaled());
	TestAssert(mesh0->isGlobalChanged());
	scene.traverse();
	TestAssert(!mesh0->isGlobalChanged());

	mesh0->setBoundingBox(AxisAlignedBox::unit);
	mesh0->setBoundingSphere(Sphere::unit);
	mesh0->setTriangleCount(1);
	Triangle triangle(0.f, 0.f, 0.f, 0.f, 0.f, 1.f, 1.f, 0.f, 0.f);
	mesh0->setTriangle(0, triangle);
	scene.getRootNode()->setScale(Vector3(1.f, 2.f, 1.f));
	scene.getRootNode()->setRotationXYZ(Vector3(Math::halfPI, 0.f, 0.f));
	scene.getRootNode()->setTranslation(Vector3(0.f, 1.f, 0.f));
	scene.traverse();
	TestAssert(mesh0->getWorldMesh().getBoundingBox().epsilonEquals(
		AxisAlignedBox(-0.5f, 0.5f, -1.f, 0.5, 1.5, 1.f), Math::epsilon));
	TestAssert(mesh0->getWorldMesh().getBoundingSphere().epsilonEquals(
		Sphere(0.f, 1.f, 0.f, 2.f), Math::epsilon));
	TestAssert(mesh0->getWorldMesh().getTriangle(0).epsilonEquals(
		Triangle(0.f, 1.f, 0.f, 0.f, 0.f, 0.f, 1.f, 1.f, 0.f), Math::epsilon));

	TestEquals(1, scene.clear());
}
//------------------------------------------------------------------------------
