//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNg`Ԃ̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/VectorInterpolator/VectorLinearInterpolatorTest.h"
#include "Animation/VectorInterpolator/VectorLinearInterpolator.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* VectorLinearInterpolatorTest::suite(){
	TestSuite* suite = new TestSuite("VectorLinearInterpolatorTest");
	suite->addTest(
		new TestCaller(VectorLinearInterpolatorTest, testConstructor));
	suite->addTest(
		new TestCaller(VectorLinearInterpolatorTest, testSetterGetter));
	suite->addTest(
		new TestCaller(VectorLinearInterpolatorTest, testInterpolate));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void VectorLinearInterpolatorTest::testConstructor(){
	TestEquals(16, (int)sizeof(VectorLinearInterpolator));
	VectorLinearInterpolator interpolator;
	TestAssert(interpolator.isVectorLinearInterpolator());
	TestAssert(interpolator.castVectorLinearInterpolator() != NULL);
	// f[^\z
	int keyCount = 5;
	interpolator.setKeyCount(5);
	for(int i = 0; i < keyCount; i++){
		float floatValue = (float)i;
		Vector3 value(floatValue, floatValue, floatValue);
		float time = floatValue * 10.f;
		interpolator.setKey(i, time, value);
	}

	// Rs[RXgN^
	VectorLinearInterpolator copy0(interpolator);
	TestAssert(interpolator.equals(copy0));

	// Zq
	interpolator = interpolator;
	VectorLinearInterpolator copy1;
	copy1 = interpolator;
	TestAssert(interpolator.equals(copy1));

	// 
	VectorLinearInterpolator* duplicate =
		interpolator.duplicate()->castVectorLinearInterpolator();
	TestAssert(interpolator.equals(*duplicate));
	delete duplicate;

	// r
	VectorLinearInterpolator equal;
	TestAssert(!interpolator.equals(equal));
	equal.setKeyCount(5);
	for(int i = 0; i < keyCount; i++){
		TestAssert(!interpolator.equals(equal));
		float floatValue = (float)i;
		Vector3 value(floatValue, floatValue, floatValue);
		float time = floatValue * 10.f;
		equal.setKey(i, time, value);
	}
	TestAssert(interpolator.equals(equal));

}
//------------------------------------------------------------------------------
// ݒA擾eXg
void VectorLinearInterpolatorTest::testSetterGetter(){
	VectorLinearInterpolator interpolator;
	int keyCount = 5;
	TestEquals(0, interpolator.getKeyCount());
	interpolator.setKeyCount(5);
	TestEquals(keyCount, interpolator.getKeyCount());
	for(int i = 0; i < keyCount; i++){
		float floatValue = (float)i;
		Vector3 value(floatValue, floatValue, floatValue);
		float time = floatValue * 10.f;
		interpolator.setKey(i, time, value);
		TestAssert(value == interpolator.getValue(i));
		TestEquals(time, interpolator.getTime(i));
	}
}
//------------------------------------------------------------------------------
// ԃeXg
void VectorLinearInterpolatorTest::testInterpolate(){
	VectorLinearInterpolator interpolator;
	// f[^\z
	int keyCount = 6;
	interpolator.setKeyCount(keyCount);
	for(int i = 0; i < keyCount; i++){
		float floatValue = (float)i;
		Vector3 value(floatValue, floatValue, floatValue);
		float time = floatValue * 10.f;
		interpolator.setKey(i, time, value);
	}

	// 
	TestAssert(interpolator.interpolate(-5.f) ==
		Vector3(0.f, 0.f, 0.f));
	TestAssert(interpolator.interpolate(0.f) ==
		Vector3(0.f, 0.f, 0.f));
	for(int i = 0; i < 50; i++){
		float time = (float)i;
		Vector3 value(time * 0.1f, time * 0.1f, time * 0.1f);
		TestAssert(value.epsilonEquals(
			interpolator.interpolate(time), Math::epsilon));
	}
	TestAssert(interpolator.interpolate(50.f) ==
		Vector3(5.f, 5.f, 5.f));
	TestAssert(interpolator.interpolate(100.f) ==
		Vector3(5.f, 5.f, 5.f));
}
//------------------------------------------------------------------------------
