//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNgԈk̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/VectorInterpolator/VectorInterpolationCompressorTest.h"
#include "Animation/VectorInterpolator/VectorInterpolationCompressor.h"
#include "Animation/VectorInterpolator/VectorArrayInterpolator.h"
#include "Animation/VectorInterpolator/VectorConstantInterpolator.h"
#include "Animation/VectorInterpolator/VectorLinearInterpolator.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* VectorInterpolationCompressorTest::suite(){
	TestSuite* suite = new TestSuite("VectorInterpolationCompressorTest");
	suite->addTest(new TestCaller(VectorInterpolationCompressorTest,
		testConstantCompress));
	suite->addTest(new TestCaller(VectorInterpolationCompressorTest,
		testLinearCompress));
	return suite;
}
//------------------------------------------------------------------------------
// 萔keXg
void VectorInterpolationCompressorTest::testConstantCompress(){
	VectorInterpolationCompressor compressor;
	VectorInterpolator* result;
	VectorArrayInterpolator source;
	source.setSize(3);
	source.setValue(0, Vector3::zero);
	source.setValue(1, Vector3(1.f, 0.f, 0.f));
	source.setValue(2, Vector3(2.f, 0.f, 0.f));

	result = compressor.compress(&source, 1.f);
	TestAssert(result->isVectorConstantInterpolator());
	TestAssert(!result->isVectorLinearInterpolator());
	TestEquals("44.44%  Key 1/3  Size 0.02/0.04Kb  Length 2",
		compressor.getResultString());
	delete result;

	result = compressor.compress(&source, 0.f);
	TestAssert(!result->isVectorConstantInterpolator());
	TestAssert(result->isVectorLinearInterpolator());
	TestEquals("88.89%  Key 2/3  Size 0.03/0.04Kb  Length 2",
		compressor.getResultString());
	delete result;
}
//------------------------------------------------------------------------------
// `keXg
void VectorInterpolationCompressorTest::testLinearCompress(){
	VectorInterpolationCompressor compressor;
	VectorInterpolator* result;
	VectorArrayInterpolator source;
	int size = 61;
	source.setSize(size);
	for(int i = 0; i < size; i++){
		Vector3 value((float)i, (float)i, (float)i);
		source.setValue(i, value);
	}
	result = compressor.compress(&source, Math::epsilon);
	TestAssert(!result->isVectorConstantInterpolator());
	TestAssert(result->isVectorLinearInterpolator());
	TestEquals("4.37%  Key 2/61  Size 0.03/0.71Kb  Length 60",
		compressor.getResultString());
	delete result;

	for(int i = 0; i < size; i++){
		float rad = Math::doublePI * 2.f * (float)i / size;
		Vector3 value(Math::sin(rad), 0.f, Math::cos(rad));
		value *= 0.5f;
		source.setValue(i, value);
	}
	result = compressor.compress(&source, 0.1f);
	TestAssert(!result->isVectorConstantInterpolator());
	TestAssert(result->isVectorLinearInterpolator());
	TestEquals("32.79%  Key 15/61  Size 0.23/0.71Kb  Length 60",
		compressor.getResultString());
	delete result;

	result = compressor.compress(&source, 0.f);
	TestAssert(!result->isVectorConstantInterpolator());
	TestAssert(!result->isVectorLinearInterpolator());
	TestAssert(result->isVectorArrayInterpolator());
	TestEquals("100.00%  Key 61/61  Size 0.71/0.71Kb  Length 60",
		compressor.getResultString());
	delete result;
}
//------------------------------------------------------------------------------
