//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNg萔Ԃ̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/VectorInterpolator/VectorConstantInterpolatorTest.h"
#include "Animation/VectorInterpolator/VectorConstantInterpolator.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* VectorConstantInterpolatorTest::suite(){
	TestSuite* suite = new TestSuite("VectorConstantInterpolatorTest");
	suite->addTest(
		new TestCaller(VectorConstantInterpolatorTest, testConstructor));
	suite->addTest(
		new TestCaller(VectorConstantInterpolatorTest, testSetterGetter));
	suite->addTest(
		new TestCaller(VectorConstantInterpolatorTest, testInterpolate));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void VectorConstantInterpolatorTest::testConstructor(){
	TestEquals(20, (int)sizeof(VectorConstantInterpolator));
	VectorConstantInterpolator interpolator;
	TestAssert(interpolator.isVectorConstantInterpolator());
	Vector3 value(1.f, 2.f, 3.f);
	interpolator.setValue(value);
	// Rs[RXgN^
	VectorConstantInterpolator copy0(interpolator);
	TestAssert(interpolator.equals(copy0));
	// Zq
	interpolator = interpolator;
	VectorConstantInterpolator copy1;
	copy1 = interpolator;
	TestAssert(interpolator.equals(copy1));
	// 
	VectorConstantInterpolator* duplicate =
		interpolator.duplicate()->castVectorConstantInterpolator();
	TestAssert(interpolator.equals(*duplicate));
	delete duplicate;
	// r
	VectorConstantInterpolator equal;
	equal.setValue(Vector3::zero);
	TestAssert(!interpolator.equals(equal));
	equal.setValue(value);
	TestAssert(interpolator.equals(equal));
}
//------------------------------------------------------------------------------
// ݒA擾eXg
void VectorConstantInterpolatorTest::testSetterGetter(){
	VectorConstantInterpolator interpolator;
	Vector3 value(1.f, 2.f, 3.f);
	interpolator.setValue(value);
	TestAssert(interpolator.getValue() == value);
}
//------------------------------------------------------------------------------
// ԃeXg
void VectorConstantInterpolatorTest::testInterpolate(){
	VectorConstantInterpolator interpolator;
	Vector3 value(1.f, 2.f, 3.f);
	interpolator.setValue(value);
	for(int i = 0; i < 20; i++){
		float time = i - 10.f;
		TestAssert(interpolator.interpolate(time) == value);
	}
}
//------------------------------------------------------------------------------
