//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNgzԂ̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/VectorInterpolator/VectorArrayInterpolatorTest.h"
#include "Animation/VectorInterpolator/VectorArrayInterpolator.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* VectorArrayInterpolatorTest::suite(){
	TestSuite* suite = new TestSuite("VectorArrayInterpolatorTest");
	suite->addTest(
		new TestCaller(VectorArrayInterpolatorTest, testConstructor));
	suite->addTest(
		new TestCaller(VectorArrayInterpolatorTest, testSetterGetter));
	suite->addTest(
		new TestCaller(VectorArrayInterpolatorTest, testInterpolate));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void VectorArrayInterpolatorTest::testConstructor(){
	TestEquals(16, (int)sizeof(VectorArrayInterpolator));
	VectorArrayInterpolator interpolator;
	TestAssert(interpolator.isVectorArrayInterpolator());
	TestEquals(0.f, interpolator.getLength());
	// f[^\z
	int length = 5;
	int size = length + 1;
	interpolator.setSize(size);
	TestEquals((float)length, interpolator.getLength());
	for(int i = 0; i < size; i++){
		Vector3 value((float)i, (float)i, (float)i);
		interpolator.setValue(i, value);
		TestAssert(interpolator.getValue(i) == value);
	}
	// Rs[RXgN^
	VectorArrayInterpolator copy0(interpolator);
	TestAssert(interpolator.equals(copy0));
	// Zq
	interpolator = interpolator;
	VectorArrayInterpolator copy1;
	copy1 = interpolator;
	TestAssert(interpolator.equals(copy1));
	// 
	VectorArrayInterpolator* duplicate =
		interpolator.duplicate()->castVectorArrayInterpolator();
	TestAssert(interpolator.equals(*duplicate));
	delete duplicate;
	// r
	VectorArrayInterpolator equal;
	TestAssert(!interpolator.equals(equal));
	equal.setSize(size);
	for(int i = 0; i < size; i++){
		TestAssert(!interpolator.equals(equal));
		Vector3 value((float)i, (float)i, (float)i);
		equal.setValue(i, value);
	}
	TestAssert(interpolator.equals(equal));
}
//------------------------------------------------------------------------------
// ݒA擾eXg
void VectorArrayInterpolatorTest::testSetterGetter(){
	VectorArrayInterpolator interpolator;
	int size = 21;
	interpolator.setSize(size);
	TestEquals(size, interpolator.getSize());
	TestEquals((float)(size - 1), interpolator.getLength());
	for(int i = 0; i < size; i++){
		Vector3 value((float)i, (float)i, (float)i);
		interpolator.setValue(i, value);
		TestAssert(interpolator.getValue(i) == value);
	}
}
//------------------------------------------------------------------------------
// ԃeXg
void VectorArrayInterpolatorTest::testInterpolate(){
	// f[^\z
	VectorArrayInterpolator interpolator;
	int length = 5;
	int size = length + 1;
	interpolator.setSize(size);
	TestEquals((float)length, interpolator.getLength());
	for(int i = 0; i < size; i++){
		Vector3 value((float)i, (float)i, (float)i);
		interpolator.setValue(i, value);
		TestAssert(interpolator.getValue(i) == value);
	}
	// 
	TestAssert(interpolator.interpolate(-5.f) ==
		Vector3(0.f, 0.f, 0.f));
	TestAssert(interpolator.interpolate(0.f) ==
		Vector3(0.f, 0.f, 0.f));
	for(int i = 0; i < length; i++){
		for(int j = 0; j < 10; j++){
			float time = i + j * 0.1f;
			Vector3 value(time, time, time);
			TestAssert(interpolator.interpolate(
				time).epsilonEquals(value, Math::epsilon));
			
		}
	}
	TestAssert(interpolator.interpolate(5) ==
		Vector3(5.f, 5.f, 5.f));
	TestAssert(interpolator.interpolate(10) ==
		Vector3(5.f, 5.f, 5.f));
}
//------------------------------------------------------------------------------
