//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[VZbg̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/System/AnimationSetTest.h"
#include "Animation/System/AnimationManager.h"
#include "Animation/System/AnimationSet.h"
#include "Animation/SceneNode/SceneNodeAnimation.h"
#include "Animation/VectorInterpolator/VectorArrayInterpolator.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/SceneNode/SceneNodeManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* AnimationSetTest::suite(){
	TestSuite* suite = new TestSuite("AnimationSetTest");
	suite->addTest(new TestCaller(AnimationSetTest, testData));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void AnimationSetTest::testData(){
/*
	TestEquals(28, (int)sizeof(AnimationSet));
	AnimationManager manager;
	AnimationSet* animation0 = manager.createAnimationSet("animation0");
	TestAssert(animation0->isAnimationSet());
	// V[m[h̍쐬
	Scene* scene = LampGraphics::createScene("test");
	SceneNodeManager* sceneNodeManager = scene->getSceneNodeManager();
	SceneNode* sceneNode0 = sceneNodeManager->createSceneNode("sceneNode0");
	// l
	TestEquals(0, animation0->getAnimationCount());
	TestEquals(0, animation0->getSequenceCount());
	TestEquals(0, animation0->getSequence());
	TestEquals(0.f, animation0->getTime());
	TestEquals(0.f, animation0->getLength());
	TestAssert(animation0->isFinished());
	TestAssert(animation0->animate(0.1f, Animation::maskForce));
	TestEquals(0.0f, animation0->getTime());
	// Aj[V̏
	SceneNodeAnimation* animation1 =
		manager.createSceneNode("animation1");
	animation1->setTargetName("sceneNode0");
	TestAssert(animation1->bind(sceneNode0));
	animation1->setSequenceCount(2);
	animation1->setSequence(1);
	animation1->animate(0.1f, Animation::maskForce);
	SceneNodeAnimationData* data;
	data = animation1->getSceneNodeAnimationData(1);
	VectorArrayInterpolator* scale = new VectorArrayInterpolator();
	scale->setSize(2);
	scale->setValue(0, Vector3(0.f, 0.f, 0.f));
	scale->setValue(1, Vector3(1.f, 1.f, 1.f));
	data->setScale(scale);
	// Aj[V
	animation0->addAnimation(animation1);
	TestEquals(1, animation0->getAnimationCount());
	TestAssert(animation0->getAnimation(0) == animation1);
	TestEquals(2, animation0->getSequenceCount());
	TestEquals(1, animation0->getSequence());
	TestEquals(0.1f, animation0->getTime());
	TestEquals(1.f, animation0->getLength());
	TestAssert(!animation0->isFinished());
	animation0->animate(0.1f, Animation::maskForce);
	TestEquals(0.2f, animation0->getTime());
	TestAssert(!animation0->isFinished());
	// ڂ̃Aj[V
	SceneNodeAnimation* animation2 =
		manager.createSceneNode("animation2");
	animation2->setTargetName("sceneNode0");
	TestAssert(animation2->bind(sceneNode0));
	animation0->addAnimation(animation2);
	TestEquals(2, animation0->getAnimationCount());
	TestAssert(animation0->getAnimation(1) == animation2);
	TestEquals(0, animation0->getSequenceCount());
	animation2->setSequenceCount(3);
	TestEquals(2, animation0->getSequenceCount());
	TestEquals(0, animation0->getSequence());
	animation0->setSequence(1, 0.1f);
	TestEquals(1, animation0->getSequence());
	TestEquals(0.1f, animation0->getTime());
	animation0->animate(0.1f, Animation::maskForce);
	TestEquals(0.2f, animation0->getTime());
	TestEquals(1.f, animation0->getLength());
	data = animation2->getSceneNodeAnimationData(1);
	VectorArrayInterpolator* rotation = new VectorArrayInterpolator();
	rotation->setSize(3);
	rotation->setValue(0, Vector3(0.f, 0.f, 0.f));
	rotation->setValue(1, Vector3(0.1f, 0.1f, 0.1f));
	rotation->setValue(2, Vector3(0.2f, 0.2f, 0.2f));
	data->setRotation(rotation);
	TestEquals(2.f, animation0->getLength());
	animation0->animate(0.1f, Animation::maskForce);
	TestAssert(!animation0->isFinished());
	animation0->animate(3.f, Animation::maskForce);
	TestAssert(animation0->isFinished());//
	// ܂Ƃ߂ď
	manager.destroy(animation0);
	TestEquals(1, scene->clear());
	LampGraphics::destroyScene(scene);
*/
}
//------------------------------------------------------------------------------
