//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[V}l[W̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/System/AnimationManagerTest.h"
#include "Animation/System/AnimationManager.h"
#include "Animation/SceneNode/SceneNodeAnimation.h"
#include "Core/Renamer/CoreRenamerAll.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* AnimationManagerTest::suite(){
	TestSuite* suite = new TestSuite("AnimationManagerTest");
	suite->addTest(new TestCaller(AnimationManagerTest, testConstructor));
	suite->addTest(new TestCaller(AnimationManagerTest, testDatabase));
	suite->addTest(new TestCaller(AnimationManagerTest, testRename));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void AnimationManagerTest::testConstructor(){
//	TestEquals(40, (int)sizeof(AnimationManager));
//	AnimationManager manager;
}
//------------------------------------------------------------------------------
// f[^x[XeXg
void AnimationManagerTest::testDatabase(){
/*
	AnimationManager manager;
	// f[^x[X̍\z
	int animationCount = 257;
	String* names = new String[animationCount];
	Animation** animations = new Animation*[animationCount];
	for(int i = 0; i < animationCount; i++){
		names[i].format("animation%d", i);
	}
	for(int i = 0; i < animationCount; i++){
		animations[i] = manager.createSceneNode(names[i]);
	}
	// zANZX
	TestEquals(animationCount, manager.getCount());
	for(int i = 0; i < animationCount; i++){
		TestEquals(names[i], manager.get(i)->getName());
		TestAssert(animations[i] == manager.get(i));
	}
	// ANZX
	for(int i = 0; i < animationCount; i++){
		Animation* animation = manager.search(names[i]);
		TestAssert(animation == manager.get(i));
	}
	// j
	int destroyCount = 64;
	for(int i = 0; i < destroyCount; i++){
		manager.destroy(animations[i]);
	}
	TestEquals(manager.getCount(), (animationCount - destroyCount));
	// NA
	TestEquals(animationCount - destroyCount, manager.clear());
	TestEquals(0, manager.clear());
	delete[] animations;
	delete[] names;
*/
}
//------------------------------------------------------------------------------
// l[eXg
void AnimationManagerTest::testRename(){
/*
	AnimationManager manager;
	Animation* animation;
	animation =  manager.createSceneNode("animation");
	TestEquals("animation", animation->getName());
	animation =  manager.createSceneNode("animation");
	TestEquals("animation_0", animation->getName());
	animation =  manager.createSceneNode("animation");
	TestEquals("animation_1", animation->getName());
	// JEgl[}
	manager.setRenamer(new CountRenamer(15));
	animation =  manager.createSceneNode("animation");
	TestEquals("animation_f", animation->getName());
	animation =  manager.createSceneNode("animation");
	TestEquals("animation_10", animation->getName());
	// _l[}
	manager.setRenamer(new RandomRenamer(0));
	animation =  manager.createSceneNode("animation");
	TestEquals("animation_f35f", animation->getName());
	animation =  manager.createSceneNode("animation");
	TestEquals("animation_2932", animation->getName());
	manager.clear();
*/
}
//------------------------------------------------------------------------------
