//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * V[m[hAj[ṼeXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/SceneNode/SceneNodeAnimationTest.h"
#include "Animation/System/AnimationManager.h"
#include "Animation/SceneNode/SceneNodeAnimation.h"
#include "Animation/VectorInterpolator/VectorArrayInterpolator.h"
#include "Graphics/System/LampGraphics.h"
#include "Graphics/SceneNode/SceneNodeManager.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* SceneNodeAnimationTest::suite(){
	TestSuite* suite = new TestSuite("SceneNodeAnimationTest");
	suite->addTest(new TestCaller(SceneNodeAnimationTest, testData));
	suite->addTest(new TestCaller(SceneNodeAnimationTest, testAnimationData));
	suite->addTest(new TestCaller(SceneNodeAnimationTest, testAnimation));
	return suite;
}
//------------------------------------------------------------------------------
// f[^eXg
void SceneNodeAnimationTest::testData(){
/*
	TestEquals(44, (int)sizeof(SceneNodeAnimation));
	AnimationManager manager;
	SceneNodeAnimation* animation0 =
		manager.createSceneNode("animation0");
	TestAssert(animation0->isSceneNodeAnimation());
	animation0->setTargetName("target");
	TestEquals("target", animation0->getTargetName());
	TestEquals(0.f, animation0->getTime());
	animation0->setTime(10.f);
	TestEquals(10.f, animation0->getTime());
	TestEquals(0, animation0->getSequenceCount());
	animation0->setSequenceCount(2);
	TestEquals(2, animation0->getSequenceCount());
	TestEquals(0, animation0->getSequence());
	animation0->setSequence(1, 5.f);
	TestEquals(1, animation0->getSequence());
	TestEquals(5.f, animation0->getTime());
	// f[^eXg
	SceneNodeAnimation* animation1 = animation0->copySceneNodeAnimation();
	TestEquals("target", animation1->getTargetName());
	TestEquals(5.f, animation1->getTime());
	TestEquals(2, animation1->getSequenceCount());
	TestEquals(1, animation1->getSequence());
	manager.clear();
*/
}
//------------------------------------------------------------------------------
// Aj[Vf[^eXg
void SceneNodeAnimationTest::testAnimationData(){
/*
	AnimationManager manager;
	SceneNodeAnimation* animation0 =
		manager.createSceneNode("animation0");
	animation0->setSequenceCount(1);
	SceneNodeAnimationData* data = animation0->getSceneNodeAnimationData(0);
	TestEquals(0.f, data->getLength());

	TestAssert(data->getScale() == NULL);
	VectorArrayInterpolator* scale = new VectorArrayInterpolator();
	scale->setSize(2);
	scale->setValue(0, Vector3(0.f, 0.f, 0.f));
	scale->setValue(1, Vector3(1.f, 1.f, 1.f));
	data->setScale(scale);
	TestAssert(data->getScale() == scale);
	TestEquals(1.f, data->getLength());

	VectorArrayInterpolator* rotation = new VectorArrayInterpolator();
	rotation->setSize(3);
	rotation->setValue(0, Vector3(0.f, 0.f, 0.f));
	rotation->setValue(1, Vector3(0.1f, 0.1f, 0.1f));
	rotation->setValue(2, Vector3(0.2f, 0.2f, 0.2f));
	TestAssert(data->getRotation() == NULL);
	data->setRotation(rotation);
	TestAssert(data->getRotation() == rotation);
	TestEquals(2.f, data->getLength());

	VectorArrayInterpolator* translation = new VectorArrayInterpolator();
	translation->setSize(4);
	translation->setValue(0, Vector3(0.f, 0.f, 0.f));
	translation->setValue(1, Vector3(10.f, 10.f, 10.f));
	translation->setValue(2, Vector3(20.f, 20.f, 20.f));
	translation->setValue(3, Vector3(30.f, 30.f, 30.f));
	TestAssert(data->getTranslation() == NULL);
	data->setTranslation(translation);
	TestAssert(data->getTranslation() == translation);
	TestEquals(3.f, data->getLength());

	TestEquals(false, data->isLooped());
	data->setLooped(true);
	TestEquals(true, data->isLooped());

	manager.clear();
*/
}
//------------------------------------------------------------------------------
// Aj[VeXg
void SceneNodeAnimationTest::testAnimation(){
/*
	// V[m[h̍쐬
	Scene* scene = LampGraphics::createScene("test");
	SceneNodeManager* sceneNodeManager = scene->getSceneNodeManager();
	SceneNode* sceneNode0 = sceneNodeManager->createSceneNode("sceneNode0");
	// V[m[hAj[V̍쐬
	AnimationManager manager;
	SceneNodeAnimation* animation0 =
		manager.createSceneNode("animation0");
	animation0->setTargetName("sceneNode0");
	TestAssert(animation0->bind(scene));
	animation0->setSequenceCount(1);
	SceneNodeAnimationData* data = animation0->getSceneNodeAnimationData(0);
	// Aj[V
	for(int i = 0; i < 10; i++){
		animation0->animate(0.1f, Animation::maskSceneNode);
		TestAssert(sceneNode0->getScale() == Vector3(1.f, 1.f, 1.f));
		TestAssert(sceneNode0->getRotation() == Vector3(0.f, 0.f, 0.f));
		TestAssert(sceneNode0->getTranslation() == Vector3(0.f, 0.f, 0.f));
	}
	animation0->setTime(0.f);
	// XP[
	VectorArrayInterpolator* scale = new VectorArrayInterpolator();
	scale->setSize(2);
	scale->setValue(0, Vector3(0.f, 0.f, 0.f));
	scale->setValue(1, Vector3(1.f, 1.f, 1.f));
	data->setScale(scale);
	for(int i = 0; i < 10; i++){
		animation0->animate(0.1f, Animation::maskSceneNode);
		float temp = (i + 1) * 0.1f;
		TestAssert(sceneNode0->getScale().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
		TestAssert(sceneNode0->getRotation() == Vector3(0.f, 0.f, 0.f));
		TestAssert(sceneNode0->getTranslation() == Vector3(0.f, 0.f, 0.f));
	}
	animation0->setTime(0.f);
	// ]
	VectorArrayInterpolator* rotation = new VectorArrayInterpolator();
	rotation->setSize(2);
	rotation->setValue(0, Vector3(0.f, 0.f, 0.f));
	rotation->setValue(1, Vector3(0.1f, 0.1f, 0.1f));
	data->setRotation(rotation);
	for(int i = 0; i < 10; i++){
		animation0->animate(0.1f, Animation::maskSceneNode);
		float temp = (i + 1) * 0.1f;
		TestAssert(sceneNode0->getScale().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
		temp = (i + 1) * 0.01f;
		TestAssert(sceneNode0->getRotation().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
		TestAssert(sceneNode0->getTranslation() == Vector3(0.f, 0.f, 0.f));
	}
	animation0->setTime(0.f);
	// ړ
	VectorArrayInterpolator* translation = new VectorArrayInterpolator();
	translation->setSize(2);
	translation->setValue(0, Vector3(0.f, 0.f, 0.f));
	translation->setValue(1, Vector3(10.f, 10.f, 10.f));
	data->setTranslation(translation);
	for(int i = 0; i < 10; i++){
		animation0->animate(0.1f, Animation::maskSceneNode);
		float temp = (i + 1) * 0.1f;
		TestAssert(sceneNode0->getScale().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
		temp = (i + 1) * 0.01f;
		TestAssert(sceneNode0->getRotation().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
		temp = i + 1.f;
		TestAssert(sceneNode0->getTranslation().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
	}
	// [v
	animation0->setTime(1.f);
	for(int i = 0; i < 10; i++){
		animation0->animate(0.1f, Animation::maskSceneNode);
		TestAssert(sceneNode0->getScale() == Vector3(1.f, 1.f, 1.f));
		TestAssert(sceneNode0->getRotation() == Vector3(0.1f, 0.1f, 0.1f));
		TestAssert(sceneNode0->getTranslation() == Vector3(10.f, 10.f, 10.f));
	}
	data->setLooped(true);
	animation0->setTime(1.f);
	for(int i = 0; i < 9; i++){
		animation0->animate(0.1f, Animation::maskSceneNode);
		float temp = (i + 1) * 0.1f;
		TestAssert(sceneNode0->getScale().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
		temp = (i + 1) * 0.01f;
		TestAssert(sceneNode0->getRotation().epsilonEquals(
			Vector3(temp, temp, temp), Math::epsilon));
		temp = i + 1.f;
		TestAssert(sceneNode0->getTranslation().epsilonEquals(
			Vector3(temp, temp, temp), 0.00001f));
	}
	animation0->animate(0.1f, Animation::maskSceneNode);
	TestAssert(sceneNode0->getScale().epsilonEquals(
		Vector3(0.f, 0.f, 0.f), Math::epsilon));
	TestAssert(sceneNode0->getRotation().epsilonEquals(
		Vector3(0.f, 0.f, 0.f), Math::epsilon));
	TestAssert(sceneNode0->getTranslation().epsilonEquals(
		Vector3(0.f, 0.f, 0.f), 0.00001f));

	// n
	manager.clear();
	TestEquals(1, scene->clear());
	LampGraphics::destroyScene(scene);
*/
}
//------------------------------------------------------------------------------
