//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ]Ԉk̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/RotationInterpolator/RotationInterpolationCompressorTest.h"
#include "Animation/RotationInterpolator/RotationInterpolationCompressor.h"
#include "Animation/RotationInterpolator/QuaternionArrayInterpolator.h"
#include "Animation/RotationInterpolator/EulerArrayInterpolator.h"
#include "Animation/RotationInterpolator/RotationConstantInterpolator.h"
#include "Animation/RotationInterpolator/QuaternionLinearInterpolator.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* RotationInterpolationCompressorTest::suite(){
	TestSuite* suite = new TestSuite("RotationInterpolationCompressorTest");
	suite->addTest(new TestCaller(RotationInterpolationCompressorTest,
		testConstantCompress));
	suite->addTest(new TestCaller(RotationInterpolationCompressorTest,
		testLinearCompress));
	return suite;
}
//------------------------------------------------------------------------------
// 萔keXg
void RotationInterpolationCompressorTest::testConstantCompress(){
	RotationInterpolationCompressor compressor;
	RotationInterpolator* result;
	QuaternionArrayInterpolator source;
	EulerArrayInterpolator* eulerSource;
	Quaternion quaternion;
	source.setSize(3);
	quaternion.setRotationAxis(Vector3::unitX, 0.f);
	source.setValue(0, quaternion);
	quaternion.setRotationAxis(Vector3::unitX, 0.5f);
	source.setValue(1, quaternion);
	quaternion.setRotationAxis(Vector3::unitX, 1.f);
	source.setValue(2, quaternion);
	eulerSource = source.convertEulerArrayInterpolator();

	result = compressor.compress(&source, 1.f);
	TestAssert(result->isRotationConstantInterpolator());
	TestAssert(!result->isQuaternionLinearInterpolator());
	TestEquals("41.67%  Key 1/3  Size 0.02/0.05Kb  Length 2",
		compressor.getResultString());
	delete result;

	result = compressor.compress(eulerSource, 1.f);
	TestAssert(result->isRotationConstantInterpolator());
	TestAssert(!result->isQuaternionLinearInterpolator());
	TestEquals("41.67%  Key 1/3  Size 0.02/0.05Kb  Length 2",
		compressor.getResultString());
	delete result;

	result = compressor.compress(&source, 0.f);
	TestAssert(!result->isRotationConstantInterpolator());
	TestAssert(result->isQuaternionLinearInterpolator());
	TestEquals("83.33%  Key 2/3  Size 0.04/0.05Kb  Length 2",
		compressor.getResultString());
	delete result;

	result = compressor.compress(eulerSource, 0.f);
	TestAssert(!result->isRotationConstantInterpolator());
	TestAssert(result->isQuaternionLinearInterpolator());
	TestEquals("83.33%  Key 2/3  Size 0.04/0.05Kb  Length 2",
		compressor.getResultString());
	delete result;

	delete eulerSource;

	// ks
	quaternion.setRotationAxis(Vector3::unitX, 2.f);
	source.setValue(2, quaternion);
	eulerSource = source.convertEulerArrayInterpolator();

	result = compressor.compress(&source, 0.f);
	TestAssert(!result->isRotationConstantInterpolator());
	TestAssert(!result->isQuaternionLinearInterpolator());
	TestAssert(result->isQuaternionArrayInterpolator());
	TestEquals("100.00%  Key 3/3  Size 0.05/0.05Kb  Length 2",
		compressor.getResultString());
	delete result;

	result = compressor.compress(eulerSource, 0.f);
	TestAssert(!result->isRotationConstantInterpolator());
	TestAssert(!result->isQuaternionLinearInterpolator());
	TestAssert(result->isQuaternionArrayInterpolator());
	TestEquals("100.00%  Key 3/3  Size 0.05/0.05Kb  Length 2",
		compressor.getResultString());
	delete result;

	delete eulerSource;

}
//------------------------------------------------------------------------------
// `keXg
void RotationInterpolationCompressorTest::testLinearCompress(){
	RotationInterpolationCompressor compressor;
	RotationInterpolator* result;
	QuaternionArrayInterpolator source;
	EulerArrayInterpolator* eulerSource;
	Quaternion quaternion;
	int size = 61;
	source.setSize(size);
	for(int i = 0; i < size; i++){
		quaternion.setRotationAxis(Vector3::unitX,
			Math::doublePI * 2.f * (float)i / size);
		source.setValue(i, quaternion);
	}
	eulerSource = source.convertEulerArrayInterpolator();

	result = compressor.compress(&source, Math::epsilon);
	TestAssert(!result->isRotationConstantInterpolator());
	TestAssert(result->isQuaternionLinearInterpolator());
#ifdef _DEBUG
	TestEquals("14.34%  Key 7/61  Size 0.14/0.95Kb  Length 60",
		compressor.getResultString());
#else
	TestEquals("22.54%  Key 11/61  Size 0.21/0.95Kb  Length 60",
		compressor.getResultString());
#endif
	delete result;

	result = compressor.compress(eulerSource, Math::epsilon);
	TestAssert(!result->isRotationConstantInterpolator());
	TestAssert(result->isQuaternionLinearInterpolator());
#ifdef _DEBUG
	TestEquals("16.39%  Key 8/61  Size 0.16/0.95Kb  Length 60",
		compressor.getResultString());
#else
	TestEquals("22.54%  Key 11/61  Size 0.21/0.95Kb  Length 60",
		compressor.getResultString());
#endif
	delete result;
	delete eulerSource;
}
//------------------------------------------------------------------------------
