//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * l]`Ԃ̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/RotationInterpolator/QuaternionLinearInterpolatorTest.h"
#include "Animation/RotationInterpolator/QuaternionLinearInterpolator.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* QuaternionLinearInterpolatorTest::suite(){
	TestSuite* suite = new TestSuite("QuaternionLinearInterpolatorTest");
	suite->addTest(
		new TestCaller(QuaternionLinearInterpolatorTest, testConstructor));
	suite->addTest(
		new TestCaller(QuaternionLinearInterpolatorTest, testSetterGetter));
	suite->addTest(
		new TestCaller(QuaternionLinearInterpolatorTest, testInterpolate));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void QuaternionLinearInterpolatorTest::testConstructor(){
	TestEquals(16, (int)sizeof(QuaternionLinearInterpolator));
	QuaternionLinearInterpolator interpolator;
	TestAssert(interpolator.isQuaternionLinearInterpolator());
	TestAssert(interpolator.castQuaternionLinearInterpolator() != NULL);
	// f[^\z
	int keyCount = 5;
	interpolator.setKeyCount(5);
	for(int i = 0; i < keyCount; i++){
		Quaternion value;
		value.setRotationAxis(Vector3::unitX, (float)i);
		float time = (float)i * 10.f;
		interpolator.setKey(i, time, value);
	}

	// Rs[RXgN^
	QuaternionLinearInterpolator copy0(interpolator);
	TestAssert(interpolator.equals(copy0));

	// Zq
	interpolator = interpolator;
	QuaternionLinearInterpolator copy1;
	copy1 = interpolator;
	TestAssert(interpolator.equals(copy1));

	// 
	QuaternionLinearInterpolator* duplicate =
		interpolator.duplicate()->castQuaternionLinearInterpolator();
	TestAssert(interpolator.equals(*duplicate));
	delete duplicate;

	// r
	QuaternionLinearInterpolator equal;
	TestAssert(!interpolator.equals(equal));
	equal.setKeyCount(5);
	for(int i = 0; i < keyCount; i++){
		TestAssert(!interpolator.equals(equal));
		float floatValue = (float)i;
		Quaternion value;
		value.setRotationAxis(Vector3::unitX, (float)i);
		float time = (float)i * 10.f;
		equal.setKey(i, time, value);
	}
	TestAssert(interpolator.equals(equal));

}
//------------------------------------------------------------------------------
// ݒA擾eXg
void QuaternionLinearInterpolatorTest::testSetterGetter(){
	QuaternionLinearInterpolator interpolator;
	int keyCount = 5;
	TestEquals(0, interpolator.getKeyCount());
	interpolator.setKeyCount(5);
	TestEquals(keyCount, interpolator.getKeyCount());
	for(int i = 0; i < keyCount; i++){
		Quaternion value;
		value.setRotationAxis(Vector3::unitX, (float)i);
		float time = (float)i * 10.f;
		interpolator.setKey(i, time, value);
		TestAssert(value == interpolator.getValue(i));
		TestEquals(time, interpolator.getTime(i));
	}
}
//------------------------------------------------------------------------------
// ԃeXg
void QuaternionLinearInterpolatorTest::testInterpolate(){
	QuaternionLinearInterpolator interpolator;
	// f[^\z
	int keyCount = 6;
	interpolator.setKeyCount(keyCount);
	for(int i = 0; i < keyCount; i++){
		Quaternion value;
		value.setRotationAxis(Vector3::unitX, (float)i);
		float time = (float)i * 10.f;
		interpolator.setKey(i, time, value);
	}

	// 
	Quaternion quaternion;
	quaternion.setRotationAxis(Vector3::unitX, 0.f);

	TestAssert(interpolator.quaternionInterpolate(-5.f) == quaternion);
	TestAssert(interpolator.quaternionInterpolate(0.f) == quaternion);
	for(int i = 0; i < 50; i++){
		float time = (float)i;
		Quaternion value;
		value.setRotationAxis(Vector3::unitX, (float)i * 0.1f);
		TestAssert(value.epsilonEquals(
			interpolator.quaternionInterpolate(time), Math::epsilon));
	}
	quaternion.setRotationAxis(Vector3::unitX, 5.f);
	TestAssert(interpolator.quaternionInterpolate(50.f) == quaternion);
	TestAssert(interpolator.quaternionInterpolate(100.f) == quaternion);
}
//------------------------------------------------------------------------------
