//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * IC[]zԂ̃eXg
 * @author Junpee
 */

#include "Test/stdafx.h"
#include "Animation/RotationInterpolator/\
EulerArrayInterpolatorTest.h"
#include "Animation/RotationInterpolator/EulerArrayInterpolator.h"

//------------------------------------------------------------------------------
// eXgXB[g̎擾
Test* EulerArrayInterpolatorTest::suite(){
	TestSuite* suite = new TestSuite("EulerArrayInterpolatorTest");
	suite->addTest(
		new TestCaller(EulerArrayInterpolatorTest, testConstructor));
	suite->addTest(
		new TestCaller(EulerArrayInterpolatorTest, testSetterGetter));
	suite->addTest(
		new TestCaller(EulerArrayInterpolatorTest, testInterpolate));
	return suite;
}
//------------------------------------------------------------------------------
// RXgN^eXg
void EulerArrayInterpolatorTest::testConstructor(){
	TestEquals(16, (int)sizeof(EulerArrayInterpolator));
	EulerArrayInterpolator interpolator;
	TestAssert(interpolator.isEulerArrayInterpolator());
	TestAssert(interpolator.isEulerInterpolator());
	TestAssert(interpolator.isQuaternionInterpolator());
	TestEquals(0.f, interpolator.getLength());
	// f[^\z
	int length = 5;
	int size = length + 1;
	interpolator.setSize(size);
	TestEquals((float)length, interpolator.getLength());
	for(int i = 0; i < size; i++){
		Vector3 value((float)i * 0.5f, (float)i * 0.5f, (float)i * 0.5f);
		interpolator.setValue(i, value);
		TestAssert(interpolator.getValue(i) == value);
	}
	// Rs[RXgN^
	EulerArrayInterpolator copy0(interpolator);
	TestAssert(interpolator.equals(copy0));
	// Zq
	interpolator = interpolator;
	EulerArrayInterpolator copy1;
	copy1 = interpolator;
	TestAssert(interpolator.equals(copy1));
	// 
	EulerArrayInterpolator* duplicate =
		interpolator.duplicate()->castEulerArrayInterpolator();
	TestAssert(interpolator.equals(*duplicate));
	delete duplicate;
	// r
	EulerArrayInterpolator equal;
	TestAssert(!interpolator.equals(equal));
	equal.setSize(size);
	TestAssert(!interpolator.equals(equal));
	for(int i = 0; i < size; i++){
		TestAssert(!interpolator.equals(equal));
		Vector3 value((float)i * 0.5f, (float)i * 0.5f, (float)i * 0.5f);
		equal.setValue(i, value);
	}
	TestAssert(interpolator.equals(equal));
}
//------------------------------------------------------------------------------
// ݒA擾eXg
void EulerArrayInterpolatorTest::testSetterGetter(){
	EulerArrayInterpolator interpolator;
	int size = 51;
	interpolator.setSize(size);
	TestEquals(size, interpolator.getSize());
	TestEquals((float)(size - 1), interpolator.getLength());
	for(int i = 0; i < size; i++){
		Vector3 value(i - 25.f, i - 25.f, i - 25.f);
		interpolator.setValue(i, value);
		for(int j = 0; j < 3; j++){
			float temp = value.array[j];
			while(true){
				if(temp < -Math::PI){
					temp += Math::doublePI;
				}else if(temp > Math::PI){
					temp -= Math::doublePI;
				}else{
					break;
				}
			}
			value.array[j] = temp;
		}
		TestAssert(interpolator.getValue(i).epsilonEquals(value, 0.00001f));
	}
}
//------------------------------------------------------------------------------
// ԃeXg
void EulerArrayInterpolatorTest::testInterpolate(){
	// f[^\z
	EulerArrayInterpolator interpolator;
	int length = 10;
	int size = length + 1;
	interpolator.setSize(size);
	TestEquals((float)length, interpolator.getLength());
	for(int i = 0; i < size; i++){
		Vector3 value(i - 5.f, i - 5.f, i - 5.f);
		interpolator.setValue(i, value);
		for(int j = 0; j < 3; j++){
			float temp = value.array[j];
			while(true){
				if(temp < -Math::PI){
					temp += Math::doublePI;
				}else if(temp > Math::PI){
					temp -= Math::doublePI;
				}else{
					break;
				}
			}
			value.array[j] = temp;
		}
		TestAssert(interpolator.getValue(i).epsilonEquals(
			value, Math::epsilon));
	}
	// 
	float correctValue = 1.28318548f;
	TestAssert(interpolator.eulerInterpolate(-5.f) ==
		Vector3(correctValue, correctValue, correctValue));
	TestAssert(interpolator.eulerInterpolate(0.f) ==
		Vector3(correctValue, correctValue, correctValue));
	for(int i = 0; i < length; i++){
		for(int j = 0; j < 10; j++){
			float time = i + j * 0.1f;
			Vector3 result = interpolator.eulerInterpolate(time);
			TestAssert(result.x <= Math::PI);
			TestAssert(result.x >= -Math::PI);
			TestAssert(result.y <= Math::PI);
			TestAssert(result.y >= -Math::PI);
			TestAssert(result.z <= Math::PI);
			TestAssert(result.z >= -Math::PI);
			float temp = time - 5.f;
			while(true){
				if(temp < -Math::PI){
					temp += Math::doublePI;
				}else if(temp > Math::PI){
					temp -= Math::doublePI;
				}else{
					break;
				}
			}
//			TestEpsilonEquals(temp, result.x, Math::epsilon);
//			TestEpsilonEquals(temp, result.y, Math::epsilon);
//			TestEpsilonEquals(temp, result.z, Math::epsilon);
		}
	}
	correctValue = -1.28318524f;
	TestAssert(interpolator.eulerInterpolate(10) ==
		Vector3(correctValue, correctValue, correctValue));
	TestAssert(interpolator.eulerInterpolate(15) ==
		Vector3(correctValue, correctValue, correctValue));
}
//------------------------------------------------------------------------------
