//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TEh\͎
 * @author Junpee
 */

#include "LampBasic.h"
#include "Sound/System/SoundCapacity.h"
#include "Sound/System/SoundDefinition.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SoundCapacity::SoundCapacity() : directSound_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
SoundCapacity::~SoundCapacity(){
}
//------------------------------------------------------------------------------
// 
bool SoundCapacity::initialize(DirectSound* directSound){
	directSound_ = directSound;
	if(!refresh()){ return false; }
	// \͂ɓKȂĂDirectSoundΉĂH
//	if(!checkCapacity()){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// XV
bool SoundCapacity::refresh(){
	capacity_.dwSize = sizeof(DSCAPS);
	if(DirectXFailed(directSound_->GetCaps(&capacity_))){
		ErrorOut("SoundCapacity::refresh() TEh\͂̎擾Ɏs܂");
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// \̓`FbN
bool SoundCapacity::checkCapacity(){
	// vC}obt@̃`FbN
	if((SoundDefinition::primaryBufferBit == 8) &&
		(!isSupported8bitPrimaryBuffer())){
		ErrorOut("SoundCapacity::checkCapacity() "
			"8bitvC}obt@T|[gĂ܂");
		return false;
	}
	if((SoundDefinition::primaryBufferBit == 16) &&
		(!isSupported16bitPrimaryBuffer())){
		ErrorOut("SoundCapacity::checkCapacity() "
			"16bitvC}obt@T|[gĂ܂");
		return false;
	}
	if(SoundDefinition::primaryBufferStereo){
		if(!isSupportedStereoPrimaryBuffer()){
			ErrorOut("SoundCapacity::checkCapacity() "
				"XeIvC}obt@T|[gĂ܂");
			return false;
		}
	}else{
		if(!isSupportedMonauralPrimaryBuffer()){
			ErrorOut("SoundCapacity::checkCapacity() "
				"mvC}obt@T|[gĂ܂");
			return false;
		}
	}
	// ZJ_obt@̃`FbN
	if((SoundDefinition::secondaryBufferBit == 8) &&
		(!isSupported8bitSecondaryBuffer())){
		ErrorOut("SoundCapacity::checkCapacity() "
			"8bitZJ_obt@T|[gĂ܂");
		return false;
	}
	if((SoundDefinition::secondaryBufferBit == 16) &&
		(!isSupported16bitSecondaryBuffer())){
		ErrorOut("SoundCapacity::checkCapacity() "
			"16bitZJ_obt@T|[gĂ܂");
		return false;
	}
	if(!isSupportedStereoSecondaryBuffer()){
		ErrorOut("SoundCapacity::checkCapacity() "
			"XeIZJ_obt@T|[gĂ܂");
		return false;
	}
	if(!isSupportedMonauralSecondaryBuffer()){
		ErrorOut("SoundCapacity::checkCapacity() "
			"mZJ_obt@T|[gĂ܂");
		return false;
	}
	if(SoundDefinition::secondaryBufferRate > getMaxSecondarySampleRate()){
		ErrorOut("SoundCapacity::checkCapacity() "
			"ZJ_obt@̃TvO[g傫܂");
		return false;
	}
	if(SoundDefinition::secondaryBufferRate < getMinSecondarySampleRate()){
		ErrorOut("SoundCapacity::checkCapacity() "
			"ZJ_obt@̃TvO[g܂");
		return false;
	}
	return true;
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String SoundCapacity::toString() const{
	String result, temp;
	result += "MicrosoftFhCo      " +
		getBoolString(isCertifiedDriver()) + "\n";
	result += "AIȎgݒ         " +
		getBoolString(isSupportedContinuousRate()) + "\n";
	result += "G~[ghCo       " +
		getBoolString(isEmulatedDriver()) + "\n";
	result += "16bitvC}obt@    " +
		getBoolString(isSupported16bitPrimaryBuffer()) + "\n";
	result += "8bitvC}obt@     " +
		getBoolString(isSupported8bitPrimaryBuffer()) + "\n";
	result += "mvC}obt@ " +
		getBoolString(isSupportedMonauralPrimaryBuffer()) + "\n";
	result += "XeIvC}obt@ " +
		getBoolString(isSupportedStereoPrimaryBuffer()) + "\n";
	result += "16bitZJ_obt@    " +
		getBoolString(isSupported16bitSecondaryBuffer()) + "\n";
	result += "8bitZJ_obt@     " +
		getBoolString(isSupported8bitSecondaryBuffer()) + "\n";
	result += "mZJ_obt@ " +
		getBoolString(isSupportedMonauralSecondaryBuffer()) + "\n";
	result += "XeIZJ_obt@ " +
		getBoolString(isSupportedStereoSecondaryBuffer()) + "\n";

	temp.format("ZJ_őTvO[g %5uHz\n",
		getMaxSecondarySampleRate());
	result += temp;
	temp.format("ZJ_ŏTvO[g %5uHz\n",
		getMinSecondarySampleRate());
	result += temp;

	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
