//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * LampTEh
 * @author Junpee
 */

#include "LampBasic.h"
#include "Sound/System/LampSound.h"
#include "Sound/System/SoundDefinition.h"
#include "Sound/System/SoundCapacity.h"
#include "Sound/System/SoundManager.h"
#include "Sound/3D/SoundListener.h"

namespace Lamp{

// DirectSound
DirectSound* LampSound::directSound_ = NULL;
// vC}obt@
DirectSoundPrimaryBuffer* LampSound::primaryBuffer_ = NULL;
// TEh\
SoundCapacity* LampSound::soundCapacity_ = NULL;
// TEh}l[W
SoundManager* LampSound::soundManager_ = NULL;
// TEhXi
SoundListener* LampSound::soundListener_;
// Tv
int LampSound::sample_ = 0;
// `l
int LampSound::channel_ = 0;
// rbg
int LampSound::bit_ = 0;
// tO
bool LampSound::isInitialized_ = false;

//------------------------------------------------------------------------------
// 
bool LampSound::initialize(HWND windowHandle){
	if(isInitialized_){ return true; }
	LampCore::initialize();
	// DirectSound쐬
	if(DirectXFailed(DirectSoundCreate8(
		&DSDEVID_DefaultPlayback, &directSound_, NULL))){
		ErrorOut("LampSound::initialize() DirectSound̍쐬Ɏs܂");
		return false;
	}
	// x̐ݒ
	if(DirectXFailed(directSound_->SetCooperativeLevel(
		windowHandle, DSSCL_PRIORITY))){
		ErrorOut("LampSound::initialize() x̐ݒɎs܂");
		return false;
	}
	// TEh̍Ĕzu
	if(DirectXFailed(directSound_->Compact())){
		ErrorOut("LampSound::initialize() TEh̍ĔzuɎs܂");
		return false;
	}
	// TEh\͂̎擾
	soundCapacity_ = new SoundCapacity();
	if(!soundCapacity_->initialize(directSound_)){
		ErrorOut("LampSound::initialize() TEh\͂̎擾Ɏs܂");
		return false;
	}
	// vC}obt@̍쐬
	DSBUFFERDESC bufferDescription;
	::memset(&bufferDescription, 0, sizeof(DSBUFFERDESC));
	bufferDescription.dwSize = sizeof(DSBUFFERDESC);
	// vC}obt@A3DXi
	bufferDescription.dwFlags = (DSBCAPS_PRIMARYBUFFER | DSBCAPS_CTRL3D);
	if(DirectXFailed(directSound_->CreateSoundBuffer(
		&bufferDescription, &primaryBuffer_, NULL))){
		ErrorOut("LampSound::initialize() "
			"vC}obt@̍쐬Ɏs܂");
		return false;
	}
	// vC}obt@̃tH[}bgw
	WAVEFORMATEX waveFormat;
	::memset(&waveFormat, 0, sizeof(WAVEFORMATEX));
	waveFormat.wFormatTag = WAVE_FORMAT_PCM;
	if(SoundDefinition::primaryBufferStereo){
		waveFormat.nChannels = 2;
	}else{
		waveFormat.nChannels = 1;
	}
	waveFormat.nSamplesPerSec = SoundDefinition::primaryBufferRate;
	waveFormat.wBitsPerSample = SoundDefinition::primaryBufferBit;
	waveFormat.nBlockAlign =
		(waveFormat.nChannels * waveFormat.wBitsPerSample) / 8;
	waveFormat.nAvgBytesPerSec =
		waveFormat.nSamplesPerSec * waveFormat.nBlockAlign;
	if(DirectXFailed(primaryBuffer_->SetFormat(&waveFormat))){
		ErrorOut("LampSound::initialize() "
			"vC}obt@̃tH[}bgݒɎs܂");
		return false;
	}
	// tH[}bg̎擾
	::memset(&waveFormat, 0, sizeof(WAVEFORMATEX));
	if(DirectXFailed(primaryBuffer_->GetFormat(
		&waveFormat, sizeof(WAVEFORMATEX), NULL))){
		ErrorOut("LampSound::initialize() "
			"vC}obt@̃tH[}bg擾Ɏs܂");
		return false;
	}
	sample_ = waveFormat.nSamplesPerSec;
	channel_ = waveFormat.nChannels;
	bit_ = waveFormat.wBitsPerSample;
	// TEh}l[W
	soundManager_ = new SoundManager(directSound_);
	// TEhXȉ
	soundListener_ = new SoundListener(primaryBuffer_);
	// tOĂ
	isInitialized_ = true;
	return true;
}
//------------------------------------------------------------------------------
// n
void LampSound::finalize(){
	// TEhXi
	SafeDelete(soundListener_);
	// TEh}l[W
	SafeDelete(soundManager_);
	// TEh\͉
	SafeDelete(soundCapacity_);
	// vC}obt@
	SafeRelease(primaryBuffer_);
	// DirectSound
	SafeRelease(directSound_);
	// tONA
	isInitialized_ = false;
}
//------------------------------------------------------------------------------
// v[e[V
void LampSound::presentation(){
	if(!isInitialized_){ return; }
	// TEh̍XV
	soundManager_->update();
	// 3DݒKp
	soundListener_->apply3DSettings();
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String LampSound::toString(){
	Assert(isInitialized_);
	String result;
	result.format("PrimarySoundBuffer  %dHz %dChannel %dBit",
		getSample(), getChannel(), getBit());
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
