//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Xg[TEh
 * @author Junpee
 */

#include "LampBasic.h"
#include "Sound/Stereo/StreamSound.h"
#include "Sound/Reader/SoundReader.h"
#include "Sound/Utility/StreamPlayer.h"
#include "Sound/System/LampSound.h"
#include "Sound/System/SoundManager.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
StreamSound::StreamSound(DirectSoundBuffer* soundBuffer) :
	StereoSound(soundBuffer), soundReader_(NULL), streamPlayer_(NULL){
}
//------------------------------------------------------------------------------
// fXgN^
StreamSound::~StreamSound(){
	SafeDelete(streamPlayer_);
	SafeDelete(soundReader_);
}
//------------------------------------------------------------------------------
// TEh[_̐ݒ
void StreamSound::setSoundReader(SoundReader* soundReader){
	Assert(soundReader_ == NULL);
	soundReader_ = soundReader;
	Assert(soundReader_ != NULL);
	// Œobt@̃TEhKvƂ
	Assert(getSize() >= (getBufferSize() / 2));
	// Xg[v[
	streamPlayer_ = new StreamPlayer();
	streamPlayer_->initialize(this, soundReader_);
}
//------------------------------------------------------------------------------
// TCY̎擾
u_int StreamSound::getSize() const{
	Assert(soundReader_ != NULL);
	return soundReader_->getSize();
}
//------------------------------------------------------------------------------
// Đ
//------------------------------------------------------------------------------
// ~
void StreamSound::stop(){
	SoundBuffer::stop();
	// obt@̊Jnʒu炵ăXg[v[Zbg
	SoundBuffer::setCursor(0);
	streamPlayer_->reset();
}
//------------------------------------------------------------------------------
// Đʒu
//------------------------------------------------------------------------------
// Đʒuݒ
void StreamSound::setCursor(u_int cursor){
	Assert(streamPlayer_ != NULL);
	streamPlayer_->setCursor(cursor);
}
//------------------------------------------------------------------------------
// Đʒu擾
u_int StreamSound::getCursor() const{
	Assert(streamPlayer_ != NULL);
	return streamPlayer_->getCursor();
}
//------------------------------------------------------------------------------
// [v
//------------------------------------------------------------------------------
// [vʒu̐ݒ
void StreamSound::setLoopCursor(u_int loopCursor){
	Assert(streamPlayer_ != NULL);
	streamPlayer_->setLoopCursor(loopCursor);
}
//------------------------------------------------------------------------------
// [vʒu̎擾
u_int StreamSound::getLoopCursor() const{
	Assert(streamPlayer_ != NULL);
	return streamPlayer_->getLoopCursor();
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
