//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XeITEh
 * @author Junpee
 */

#include "LampBasic.h"
#include "Sound/Stereo/StereoSound.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
StereoSound::StereoSound(DirectSoundBuffer* soundBuffer) :
	SoundBuffer(soundBuffer), pan_(0.f){
	// f[^̎擾
	long decibelPan;
	if(DirectXFailed(soundBuffer->GetPan(&decibelPan))){
		ErrorOut("StereoSound::StereoSound() p̎擾Ɏs܂B");
	}
	int absDecibelPan = Math::abs(decibelPan);
	pan_ = 1.f - decibelToVolume(-absDecibelPan);
	if(decibelPan < 0.f){ pan_ = -pan_; }
}
//------------------------------------------------------------------------------
// fXgN^
StereoSound::~StereoSound(){
}
//------------------------------------------------------------------------------
// XeITEhf[^̃Rs[
void StereoSound::copyStereoSoundData(StereoSound* destination){
	copySoundBufferData(destination);
}
//------------------------------------------------------------------------------
// p̐ݒ
void StereoSound::setPan(float pan){
	if(pan_ == pan){ return; }
	Assert(pan >= -1.f);
	Assert(pan <= 1.f);
	float absPan = Math::abs(pan);
	if(absPan <= 0.002f){// 0.002fȉdb0ɂȂ
		if(DirectXFailed(getSoundBuffer()->SetPan(DSBPAN_CENTER))){
			ErrorOut("StereoSound::setPan() p̐ݒɎs܂B");
		}
	}else{
		// Pan͐Βl01ɋ߂ÂAʂ
		int db = volumeToDecibel(1.f - absPan);
		if(db == 0){ db = DSBPAN_LEFT; }
		Assert((db <= DSBPAN_CENTER) && (db >= DSBPAN_LEFT));
		if(pan > 0.f){ db = -db; }
		if(DirectXFailed(getSoundBuffer()->SetPan(db))){
			ErrorOut("StereoSound::setPan() p̐ݒɎs܂B");
		}
	}
	pan_ = pan;
}
//------------------------------------------------------------------------------
// Zbg
void StereoSound::reset(Reset flags){
	SoundBuffer::reset(flags);
	if((flags & resetPan) != 0){ setPan(0.f); }
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String StereoSound::toString() const{
	String result, temp;
	result = SoundBuffer::toString();
	temp.format("Pan(%.2f) BufferSize(%7dbyte)\n",
		getPan(), getBufferSize());
	result += temp;
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
