//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OggVorbis[_
 * @author Junpee
 */

#include "LampBasic.h"
#include "Sound/Reader/OggVorbisReader.h"
#include "vorbis/vorbisfile.h"

namespace Lamp{

//------------------------------------------------------------------------------
// OggVorbis[_NX
//------------------------------------------------------------------------------
/**
 * OggVorbis[_NX
 */
class OggVorbisReaderImpl{
public:
	/**
	 * RXgN^
	 * @param filePath t@CpX
	 */
	OggVorbisReaderImpl(const FilePath& filePath) : filePath_(filePath),
		file_(NULL), cursor_(0), pcmScale_(0),
		size_(0), sample_(0), channel_(0), bit_(0),
		oggVorbisinitialized_(false), initialized_(false){
		::memset(&oggVorbis_, 0, sizeof(OggVorbis_File));
	}

	/**
	 * fXgN^
	 */
	virtual ~OggVorbisReaderImpl(){
		int result;
		if(file_ != NULL){
			if(oggVorbisinitialized_){
				result = ov_clear(&oggVorbis_);
				Assert(result == 0);
			}else{
				result = fclose(file_);
				Assert(result == 0);
			}
		}
	}

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual u_int getSize() const{
		Assert(initialized_);
		return size_;
	}

	/**
	 * Tv̎擾
	 * @return Tv
	 */
	virtual int getSample() const{
		Assert(initialized_);
		return sample_;
	}

	/**
	 * `l̎擾
	 * @return `l
	 */
	virtual int getChannel() const{
		Assert(initialized_);
		return channel_;
	}

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	virtual int getBit() const{
		Assert(initialized_);
		return bit_;
	}

	/**
	 * Rg̎擾
	 * @return Rg
	 */
	virtual const String& getComment(){
		Assert(initialized_);
		return comment_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ʒu̐ݒ
	 * @param cursor ݒ肷ʒu
	 */
	virtual void setCursor(u_int cursor){
		Assert((cursor % pcmScale_) == 0);
		if(ov_pcm_seek(&oggVorbis_, cursor / pcmScale_) != 0){
			ErrorOut("OggVorbisReader::setCursor() ʒu̐ݒɎs܂B");
		}
		cursor_ = cursor;
	}

	/**
	 * ʒu̎擾
	 * @return ʒu
	 */
	virtual u_int getCursor(){ return cursor_; }

	//--------------------------------------------------------------------------
	/**
	 * wb_ǂݍ
	 * @return true
	 */
	virtual bool readHeader(){
		if(!filePath_.existFile()){ return false; }
		file_ = fopen(filePath_.getPath().getBytes(), "rb");
		if(file_ == NULL){ return false; }
		// OggVorbisJ
		::memset(&oggVorbis_, 0, sizeof(OggVorbis_File));
		int result = ov_open(file_, &oggVorbis_, NULL, 0);
		// KvȂG[R[h̎ʓ
		if(result < 0){ return false; }
		oggVorbisinitialized_ = true;
		// V[N\
		if(ov_seekable(&oggVorbis_) == 0){ return false; }
		// ̎擾
		vorbis_info* info = ov_info(&oggVorbis_, -1);
		if(info == NULL){ return false; }
		sample_ = info->rate;
		Assert((sample_ >= DSBFREQUENCY_MIN) && (sample_ <= 100000));
		channel_ = info->channels;
		Assert((channel_ == 1) || (channel_ == 2));
		// 16bittH[}bgw
		bit_ = 16;
		Assert((bit_ == 8) || (bit_ == 16));
		pcmScale_ = 2 * channel_;
		// TCY擾
		__int64 size = ov_pcm_total(&oggVorbis_, -1);
		if(size < 0){ return false; }
		size *= pcmScale_;
		if(size > Limit::uIntMax){ return false; }
		size_ = (u_int)size;
		// Rg̓ǂݍ
		vorbis_comment* commnets = ov_comment(&oggVorbis_,-1);
		int commentCount = commnets->comments;
		for(int i = 0; i < commentCount; i++){
			String comment = commnets->user_comments[i];
			if(comment.startsWith("COMMENT=")){
				comment_ = comment.getSubstring(8);
			}
		}
		setCursor(0);
		initialized_ = true;
		return true;
	}

	//--------------------------------------------------------------------------
	/**
	 * ǂݍ
	 * @param buffer ǂݍ݃obt@
	 * @param size ǂݍ݃TCY
	 * @return ǂݍ񂾃TCYBI[Ȃ0As-1
	 */
	virtual int read(void* buffer, u_int size){
		char* readBuffer = (char*)buffer;
		int readSize = 0;
		while(true){
			// gGfBAA16bittH[}bgAt
			int result = ov_read(&oggVorbis_,
				(readBuffer + readSize), (size - readSize), 0, 2, 1, NULL);
			if(result < 0){ return -1; }
			readSize += result;
			cursor_ += result;
			if((size == readSize) || (result == 0)){ break; }
		}
		Assert(size == readSize);
		return readSize;
	}

private:
	//--------------------------------------------------------------------------
	// t@CpX
	FilePath filePath_;
	// t@C
	FILE* file_;
	// OggVorbis
	OggVorbis_File oggVorbis_;
	// Rg
	String comment_;
	// ǂݍ݈ʒu
	u_int cursor_;
	// PCMXP[
	u_int pcmScale_;

	// TCY
	u_int size_;
	// Tv
	int sample_;
	// `l
	int channel_;
	// rbg
	int bit_;
	// OggVorbisς݃tO
	bool oggVorbisinitialized_;
	// ς݃tO
	bool initialized_;

};
//------------------------------------------------------------------------------
// OggVorbisReader
//------------------------------------------------------------------------------
// RXgN^
OggVorbisReader::OggVorbisReader(const FilePath& filePath){
	implement_ = new OggVorbisReaderImpl(filePath);
}
//------------------------------------------------------------------------------
// fXgN^
OggVorbisReader::~OggVorbisReader(){
	SafeDelete(implement_);
}
//------------------------------------------------------------------------------
// TCY̎擾
u_int OggVorbisReader::getSize() const{ return implement_->getSize(); }
//------------------------------------------------------------------------------
// Tv̎擾
int OggVorbisReader::getSample() const{ return implement_->getSample(); }
//------------------------------------------------------------------------------
// `l̎擾
int OggVorbisReader::getChannel() const{ return implement_->getChannel(); }
//------------------------------------------------------------------------------
// rbg̎擾
int OggVorbisReader::getBit() const{ return implement_->getBit(); }
//------------------------------------------------------------------------------
// Rg̎擾
const String& OggVorbisReader::getComment(){ return implement_->getComment(); }
//------------------------------------------------------------------------------
// ʒu̐ݒ
void OggVorbisReader::setCursor(u_int cursor){
	implement_->setCursor(cursor);
}
//------------------------------------------------------------------------------
// ʒu̎擾
u_int OggVorbisReader::getCursor(){ return implement_->getCursor(); }
//------------------------------------------------------------------------------
// wb_ǂݍ
bool OggVorbisReader::readHeader(){ return implement_->readHeader(); }
//------------------------------------------------------------------------------
// ǂݍ
int OggVorbisReader::read(void* buffer, u_int size){
	return implement_->read(buffer, size);
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
