//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * pbh
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Pad/Pad.h"
#include "Input/Joystick/Joystick.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Pad::Pad(Joystick* joystick) : joystick_(joystick){
	Assert(joystick_ != NULL);
}
//------------------------------------------------------------------------------
// fXgN^
Pad::~Pad(){
}
//------------------------------------------------------------------------------
// O̎擾
String Pad::getName() const{
	return joystick_->getName();
}
//------------------------------------------------------------------------------
// A^b`Ă邩
bool Pad::isAttached() const{
	return joystick_->isAttached();
}
//------------------------------------------------------------------------------
// NA
void Pad::clear(){
	joystick_->clear();
}
//------------------------------------------------------------------------------
// x̐ݒ
bool Pad::setCooperativeLevel(bool exclusive, bool foreground){
	return joystick_->setCooperativeLevel(exclusive, foreground);
}
//------------------------------------------------------------------------------
// r[h
bool Pad::isExclusive() const{
	return joystick_->isExclusive();
}
//------------------------------------------------------------------------------
// tHAOEh[h
bool Pad::isForeground() const{
	return joystick_->isForeground();
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String Pad::toString() const{
	String result;
	result += getName() + " (";
	if(isExclusive()){ result += " Exclusive"; }
	else{ result += " NonExclusive"; }
	if(isForeground()){ result += " Foreground"; }
	else{ result += " Background"; }
	if(isAttached()){ result += " Attached"; }
	result += " )\n";
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
