//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * PS2݊pbh
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Pad/PS2Pad.h"
#include "Input/Joystick/Joystick.h"

namespace Lamp{

//------------------------------------------------------------------------------
// ݊`FbN
bool PS2Pad::checkCompatibility(Joystick* joystick){
	// XAYAZAZ]Kv
	// ݊pbhłȊO̊U肪݂AxisMapɑΉ
	if(!joystick->hasXAxis()){ return false; }
	if(!joystick->hasYAxis()){ return false; }
	if(!joystick->hasZAxis()){ return false; }
	if(!joystick->hasZRotation()){ return false; }
	// {^12{^Kv
	if(joystick->getButtonCount() < 12){ return false; }
	// _Rg[Kv
	if(joystick->getPOVCount() < 1){
		// 16{^SmartJoypadƔ肷
		if(joystick->getButtonCount() < 16){ return false; }
	}
	return true;
}
//------------------------------------------------------------------------------
// Aj
//------------------------------------------------------------------------------
// RXgN^
PS2Pad::PS2Pad(Joystick* joystick) : Pad(joystick){
	// ݊`FbN
	Assert(checkCompatibility(joystick_));
	// {^}bv̏
	for(int i = 0; i < maxButtonCount; i++){ buttonMap_[i] = i; }
	// POV{^16ȏ゠΃X}[gWCpbh
	isSmartJoypad_ = false;
	if((joystick_->getPOVCount() < 1) && (joystick->getButtonCount() >= 16)){
		isSmartJoypad_ = true;
		// X}[gWCpbhpɃ{^}bvC
		changeButtonMap(buttonStart, buttonSelect);
	}
}
//------------------------------------------------------------------------------
// fXgN^
PS2Pad::~PS2Pad(){
}
//------------------------------------------------------------------------------
// {^}bv
//------------------------------------------------------------------------------
// {^}bv̕ύX
void PS2Pad::changeButtonMap(Button button, int id){
	Assert((button >= 0) && (button < maxButtonCount));
	if(buttonMap_[button] == id){ return; }
	int destinationID = buttonMap_[button];
	for(int i = 0; i < maxButtonCount; i++){
		if(buttonMap_[i] == id){ buttonMap_[i] = destinationID; }
	}
	buttonMap_[button] = id;
}
//------------------------------------------------------------------------------
// f[^̎擾
//------------------------------------------------------------------------------
// X̎擾
float PS2Pad::getLeftXAxis() const{
	return joystick_->getXAxis();
}
//------------------------------------------------------------------------------
// Y̎擾
float PS2Pad::getLeftYAxis() const{
	return joystick_->getYAxis();
}
//------------------------------------------------------------------------------
// EX̎擾
float PS2Pad::getRightXAxis() const{
	if(isSmartJoypad_){ return joystick_->getZRotation(); }
	return joystick_->getZAxis();
}
//------------------------------------------------------------------------------
// EY̎擾
float PS2Pad::getRightYAxis() const{
	if(isSmartJoypad_){ return joystick_->getZAxis(); }
	return joystick_->getZRotation();
}
//------------------------------------------------------------------------------
// \L[f[^̎擾
//------------------------------------------------------------------------------
// L[Ă邩
bool PS2Pad::upKeyPressed() const{
	if(isSmartJoypad_){ return buttonPressed(buttonPOVUp); }
	return povToUpKey(joystick_->getPOV(0));
}
//------------------------------------------------------------------------------
// L[
bool PS2Pad::upKeyDown() const{
	if(isSmartJoypad_){ return buttonDown(buttonPOVUp); }
	return (povToUpKey(joystick_->getPOV(0)) &&
		(!povToUpKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// L[オ
bool PS2Pad::upKeyUp() const{
	if(isSmartJoypad_){ return buttonUp(buttonPOVUp); }
	return (!povToUpKey(joystick_->getPOV(0)) &&
		(povToUpKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// L[Ă邩
bool PS2Pad::downKeyPressed() const{
	if(isSmartJoypad_){ return buttonPressed(buttonPOVDown); }
	return povToDownKey(joystick_->getPOV(0));
}
//------------------------------------------------------------------------------
// L[
bool PS2Pad::downKeyDown() const{
	if(isSmartJoypad_){ return buttonDown(buttonPOVDown); }
	return (povToDownKey(joystick_->getPOV(0)) &&
		(!povToDownKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// L[オ
bool PS2Pad::downKeyUp() const{
	if(isSmartJoypad_){ return buttonUp(buttonPOVDown); }
	return (!povToDownKey(joystick_->getPOV(0)) &&
		(povToDownKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// L[Ă邩
bool PS2Pad::leftKeyPressed() const{
	if(isSmartJoypad_){ return buttonPressed(buttonPOVLeft); }
	return povToLeftKey(joystick_->getPOV(0));
}
//------------------------------------------------------------------------------
// L[
bool PS2Pad::leftKeyDown() const{
	if(isSmartJoypad_){ return buttonDown(buttonPOVLeft); }
	return (povToLeftKey(joystick_->getPOV(0)) &&
		(!povToLeftKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// L[オ
bool PS2Pad::leftKeyUp() const{
	if(isSmartJoypad_){ return buttonUp(buttonPOVLeft); }
	return (!povToLeftKey(joystick_->getPOV(0)) &&
		(povToLeftKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// EL[Ă邩
bool PS2Pad::rightKeyPressed() const{
	if(isSmartJoypad_){ return buttonPressed(buttonPOVRight); }
	return povToRightKey(joystick_->getPOV(0));
}
//------------------------------------------------------------------------------
// EL[
bool PS2Pad::rightKeyDown() const{
	if(isSmartJoypad_){ return buttonDown(buttonPOVRight); }
	return (povToRightKey(joystick_->getPOV(0)) &&
		(!povToRightKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// EL[オ
bool PS2Pad::rightKeyUp() const{
	if(isSmartJoypad_){ return buttonUp(buttonPOVRight); }
	return (!povToRightKey(joystick_->getPOV(0)) &&
		(povToRightKey(joystick_->getPrePOV(0))));
}
//------------------------------------------------------------------------------
// {^f[^̎擾
//------------------------------------------------------------------------------
// {^Ă邩
bool PS2Pad::buttonPressed(Button button) const{
	Assert((button >= 0) && (button < maxButtonCount));
	return joystick_->buttonPressed(buttonMap_[button]);
}
//------------------------------------------------------------------------------
// {^
bool PS2Pad::buttonDown(Button button) const{
	Assert((button >= 0) && (button < maxButtonCount));
	return joystick_->buttonDown(buttonMap_[button]);
}
//------------------------------------------------------------------------------
// {^オ
bool PS2Pad::buttonUp(Button button) const{
	Assert((button >= 0) && (button < maxButtonCount));
	return joystick_->buttonUp(buttonMap_[button]);
}
//------------------------------------------------------------------------------
// f[^擾
//------------------------------------------------------------------------------
// {^̎擾
String PS2Pad::getButtonString(Button button){
	if(button == -1){ return "Unknown"; }
	Assert((button >= 0) && (button < maxButtonCount));
	String buttonString[] = {
		"Sankaku", "Maru", "Batu", "Sikaku",
		"L2", "R2", "L1", "R1", "Start", "Select", "L3", "R3",
	};
	return buttonString[button];
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String PS2Pad::toString() const{
	String result, temp;
	result = Pad::toString();
	// f[^
	temp.format(" Axis ( %5.2f , %5.2f ) ( %5.2f , %5.2f )\n",
		getLeftXAxis(), getLeftYAxis(), getRightXAxis(), getRightYAxis());
	result += temp;
	// \L[
	result += "          Press Down   Up\n";
	temp.format(" UpKey        %d    %d    %d\n",
		upKeyPressed(), upKeyDown(), upKeyUp());
	result += temp;
	temp.format(" DownKey      %d    %d    %d\n",
		downKeyPressed(), downKeyDown(), downKeyUp());
	result += temp;
	temp.format(" LeftKey      %d    %d    %d\n",
		leftKeyPressed(), leftKeyDown(), leftKeyUp());
	result += temp;
	temp.format(" RightKey     %d    %d    %d\n",
		rightKeyPressed(), rightKeyDown(), rightKeyUp());
	result += temp;
	// {^
	temp.format(" Sankaku      %d    %d    %d\n",
		buttonPressed(buttonSankaku), buttonDown(buttonSankaku),
		buttonUp(buttonSankaku));
	result += temp;
	temp.format(" Maru         %d    %d    %d\n",
		buttonPressed(buttonMaru), buttonDown(buttonMaru),
		buttonUp(buttonMaru));
	result += temp;
	temp.format(" Batu         %d    %d    %d\n",
		buttonPressed(buttonBatu), buttonDown(buttonBatu),
		buttonUp(buttonBatu));
	result += temp;
	temp.format(" Sikaku       %d    %d    %d\n",
		buttonPressed(buttonSikaku), buttonDown(buttonSikaku),
		buttonUp(buttonSikaku));
	result += temp;
	temp.format(" L2           %d    %d    %d\n",
		buttonPressed(buttonL2), buttonDown(buttonL2),
		buttonUp(buttonL2));
	result += temp;
	temp.format(" R2           %d    %d    %d\n",
		buttonPressed(buttonR2), buttonDown(buttonR2),
		buttonUp(buttonR2));
	result += temp;
	temp.format(" L1           %d    %d    %d\n",
		buttonPressed(buttonL1), buttonDown(buttonL1),
		buttonUp(buttonL1));
	result += temp;
	temp.format(" R1           %d    %d    %d\n",
		buttonPressed(buttonR1), buttonDown(buttonR1),
		buttonUp(buttonR1));
	result += temp;
	temp.format(" Start        %d    %d    %d\n",
		buttonPressed(buttonStart), buttonDown(buttonStart),
		buttonUp(buttonStart));
	result += temp;
	temp.format(" Select       %d    %d    %d\n",
		buttonPressed(buttonSelect), buttonDown(buttonSelect),
		buttonUp(buttonSelect));
	result += temp;
	temp.format(" L3           %d    %d    %d\n",
		buttonPressed(buttonL3), buttonDown(buttonL3),
		buttonUp(buttonL3));
	result += temp;
	temp.format(" R3           %d    %d    %d\n",
		buttonPressed(buttonR3), buttonDown(buttonR3),
		buttonUp(buttonR3));
	result += temp;

	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
