//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }EXfoCX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Mouse/MouseDevice.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
MouseDevice::MouseDevice() : InputDevice(false){
	zResolution_ = 120;// Ƃ肠ʓI120ɂĂ
}
//------------------------------------------------------------------------------
// fXgN^
MouseDevice::~MouseDevice(){
}
//------------------------------------------------------------------------------
// 
bool MouseDevice::initialize(DirectInputDevice* inputDevice, HWND windowHandle){
	if(!InputDevice::initialize(inputDevice, windowHandle)){ return false; }
	// f[^tH[}bg̎w
	if(DirectXFailed(inputDevice->SetDataFormat(&c_dfDIMouse2))){
		ErrorOut("MouseDevice::initialize() "
			"}EXfoCX̃f[^tH[}bgwɎs܂B");
		return false;
	}
	// ZΉ𑜓x𒲂ׂ
	if((getAxisCount() >= 3) && isAttached()){
		DIPROPDWORD property;
		property.diph.dwSize = sizeof(DIPROPDWORD);
		property.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		property.diph.dwHow = DIPH_BYOFFSET;
		property.diph.dwObj = DIMOFS_Z;
		HRESULT result =
			inputDevice->GetProperty(DIPROP_GRANULARITY, &property.diph);
		if(DirectXFailed(result)){
			ErrorOut("MouseDevice::initialize() Z𑜓x̎擾Ɏs܂B");
		}else{
			zResolution_ = property.dwData;
		}
	}
	// Dx̎w
	if(!setCooperativeLevel(isExclusive(), isForeground())){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// |[O
bool MouseDevice::polling(){
	InputDevice::polling();
	// }EXfoCXXe[g擾
	DIMOUSESTATE2 state;
	HRESULT result = inputDevice_->GetDeviceState(
		sizeof(DIMOUSESTATE2), &state);
	if(DirectXSucceeded(result)){
		mouseState_.setXAxis(state.lX);
		mouseState_.setYAxis(state.lY);
		mouseState_.setZAxis(state.lZ);
		for(int i = 0; i < maxButtonCount; i++){
			mouseState_.setButtonPressed(i,
				((state.rgbButtons[i] & 0x80) != 0));
		}
		return true;
	}else{
		// G[Ȃ͖
		mouseState_.clear();
		// [ȃG[łȂ`FbN
		if((result != DIERR_INPUTLOST) && (result != DIERR_NOTACQUIRED)){
			ErrorOut("GetDeviceState()Ɏs܂B");
		}else{
			// foCXĎ擾
			acquire();
		}
	}
	return false;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
