//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * }EX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Mouse/Mouse.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Mouse::Mouse(MouseDevice* device) : device_(device),
	clickPositionRange_(3), doubleClickTimeRange_(45){
	clickStateClear();
}
//------------------------------------------------------------------------------
// fXgN^
Mouse::~Mouse(){
}
//------------------------------------------------------------------------------
// NbNXe[gNA
void Mouse::clickStateClear(){
	for(int i = 0; i < maxButtonCount; i++){
		downTime_[i] = preDownTime_[i] = -1;
		downOffset_[i].set(0, 0);
		preDownOffset_[i].set(0, 0);
		clicked_[i] = false;
		doubleClicked_[i] = false;
		doubleDown_[i] = false;
	}
}
//------------------------------------------------------------------------------
// ̃Xe[gݒ
void Mouse::setNextState(const MouseState& state){
	preState_ = state_;
	state_ = state;
	// NbN
	int buttonCount = getButtonCount();
	for(int i = 0; i < buttonCount; i++){
		// _EgKɑΉ
		if(buttonDown(i)){
			preDownTime_[i] = downTime_[i];
			preDownOffset_[i] = downOffset_[i];
			downTime_[i] = 0;
			downOffset_[i].set(0, 0);
		}
		// Xe[gXV
		if(downTime_[i] != -1){
			downOffset_[i].x += getXAxis();
			downOffset_[i].y += getYAxis();
			downTime_[i]++;
			// ړ͈̓`FbN
			if((Math::abs(downOffset_[i].x) > clickPositionRange_) ||
				(Math::abs(downOffset_[i].y) > clickPositionRange_)){
				downTime_[i] = -1;
			}
		}
		if(preDownTime_[i] != -1){
			preDownOffset_[i].x += getXAxis();
			preDownOffset_[i].y += getYAxis();
			preDownTime_[i]++;
			// ړ͈̓`FbN
			if((Math::abs(preDownOffset_[i].x) > clickPositionRange_) ||
				(Math::abs(preDownOffset_[i].y) > clickPositionRange_)){
				preDownTime_[i] = -1;
			}
		}
		// NbN
		clicked_[i] = false;
		if(buttonUp(i) && (downTime_[i] != -1)){ clicked_[i] = true; }
		// _uNbN
		doubleClicked_[i] = false;
		if(buttonUp(i) && (downTime_[i] != -1) && (preDownTime_[i] != -1) &&
			(preDownTime_[i] < doubleClickTimeRange_)){
			doubleClicked_[i] = true;
			// _uNbNAȂ悤ɂ
			downTime_[i] = -1;
		}
		// _u_E
		doubleDown_[i] = false;
		if(buttonDown(i) && (downTime_[i] != -1) &&
			(preDownTime_[i] != -1) &&
			(preDownTime_[i] < doubleClickTimeRange_)){
			doubleDown_[i] = true;
		}
	}
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String Mouse::toString() const{
	String result, temp;
	result = getName();
	result += " (";
	if(isAttached()){ result += " Attached"; }
	if(isPolled()){ result += " NeedPolling"; }
	result += " )\n";
	temp.format("( X = %4d , Y = %4d , Z = %4d ) ZResolution %d\n",
		getXAxis(), getYAxis(), getZAxis(), getZResolution());
	result += temp;
	// {^
	temp.format("Buttons %d\n", getButtonCount());
	result += temp;
	result += " Pressed    ";
	for(int i = 0; i < maxButtonCount; i++){
		if(buttonPressed(i)){ result += " 1"; }
		else{ result += " 0"; }
	}
	result += "\n";

	result += " Down       ";
	for(int i = 0; i < maxButtonCount; i++){
		if(buttonDown(i)){ result += " 1"; }
		else{ result += " 0"; }
	}
	result += "\n";

	result += " Up         ";
	for(int i = 0; i < maxButtonCount; i++){
		if(buttonUp(i)){ result += " 1"; }
		else{ result += " 0"; }
	}
	result += "\n";

	result += " Click      ";
	for(int i = 0; i < maxButtonCount; i++){
		if(clicked(i)){ result += " 1"; }
		else{ result += " 0"; }
	}
	result += "\n";

	result += " DoubleClick";
	for(int i = 0; i < maxButtonCount; i++){
		if(doubleClicked(i)){ result += " 1"; }
		else{ result += " 0"; }
	}
	result += "\n";

	result += " DoubleDown ";
	for(int i = 0; i < maxButtonCount; i++){
		if(doubleDown(i)){ result += " 1"; }
		else{ result += " 0"; }
	}
	result += "\n";
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
