//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * L[{[hXe[g
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Keyboard/KeyboardState.h"
#include "Core/InputOutput/BinaryWriter.h"
#include "Core/InputOutput/BinaryReader.h"

namespace Lamp{

//------------------------------------------------------------------------------
// oCio
void KeyboardState::writeBinary(BinaryWriter* binaryWriter) const{
	u_char pressedCount = 0;
	for(int i = 0; i < maxKeyCount; i++){
		if(keyPressed((Key)i)){ pressedCount++; }
	}
	binaryWriter->writeUChar(pressedCount);
	for(int i = 0; i < maxKeyCount; i++){
		if(keyPressed((Key)i)){ binaryWriter->writeUChar((u_char)i); }
	}
}
//------------------------------------------------------------------------------
// oCiǂݍ
void KeyboardState::readBinary(BinaryReader* binaryReader){
	for(int i = 0; i < maxKeyCount; i++){ setKeyPressed((Key)i, false); }
	u_char pressCount = binaryReader->readUChar();
	for(u_char i = 0; i < pressCount; i++){
		u_char key = binaryReader->readUChar();
		setKeyPressed((Key)key, true);
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
