//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * L[{[hL[
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Keyboard/KeyboardKey.h"

namespace Lamp{

// L[
String KeyboardKey::keyName_[maxKeyCount];
// tO
bool KeyboardKey::initialized_ = false;

//------------------------------------------------------------------------------
// L[񏉊
void KeyboardKey::initializeKeyString(){
	if(initialized_){ return; }
	String unknown("UnknownKey");
	for(int i = 0; i < maxKeyCount; i++){ keyName_[i] = unknown; }
	keyName_[keyEscape] = "Escape";
	keyName_[key1] = "1";
	keyName_[key2] = "2";
	keyName_[key3] = "3";
	keyName_[key4] = "4";
	keyName_[key5] = "5";
	keyName_[key6] = "6";
	keyName_[key7] = "7";
	keyName_[key8] = "8";
	keyName_[key9] = "9";
	keyName_[key0] = "0";
	keyName_[keyMinus] = "Minus";
	keyName_[keyEquals] = "Equals";
	keyName_[keyBackspace] = "Backspace";
	keyName_[keyTab] = "Tab";
	keyName_[keyQ] = "Q";
	keyName_[keyW] = "W";
	keyName_[keyE] = "E";
	keyName_[keyR] = "R";
	keyName_[keyT] = "T";
	keyName_[keyY] = "Y";
	keyName_[keyU] = "U";
	keyName_[keyI] = "I";
	keyName_[keyO] = "O";
	keyName_[keyP] = "P";
	keyName_[keyLeftBracket] = "LeftBracket";
	keyName_[keyRightBracket] = "RightBracket";
	keyName_[keyEnter] = "Enter";
	keyName_[keyLeftControl] = "LeftControl";
	keyName_[keyA] = "A";
	keyName_[keyS] = "S";
	keyName_[keyD] = "D";
	keyName_[keyF] = "F";
	keyName_[keyG] = "G";
	keyName_[keyH] = "H";
	keyName_[keyJ] = "J";
	keyName_[keyK] = "K";
	keyName_[keyL] = "L";
	keyName_[keySemicolon] = "Semicolon";
	keyName_[keyApostrophe] = "Apostrophe";
	keyName_[keyGrave] = "Grave";
	keyName_[keyLeftShift] = "LeftShift";
	keyName_[keyBackslash] = "Backslash";
	keyName_[keyZ] = "Z";
	keyName_[keyX] = "X";
	keyName_[keyC] = "C";
	keyName_[keyV] = "V";
	keyName_[keyB] = "B";
	keyName_[keyN] = "N";
	keyName_[keyM] = "M";
	keyName_[keyComma] = "Comma";
	keyName_[keyPeriod] = "Period";
	keyName_[keySlash] = "Slash";
	keyName_[keyRightShift] = "RightShift";
	keyName_[keyNumPadMultiply] = "NumPadMultiply";
	keyName_[keyLeftAlt] = "LeftAlt";
	keyName_[keySpace] = "Space";
	keyName_[keyCapsLock] = "CapsLock";
	keyName_[keyF1] = "F1";
	keyName_[keyF2] = "F2";
	keyName_[keyF3] = "F3";
	keyName_[keyF4] = "F4";
	keyName_[keyF5] = "F5";
	keyName_[keyF6] = "F6";
	keyName_[keyF7] = "F7";
	keyName_[keyF8] = "F8";
	keyName_[keyF9] = "F9";
	keyName_[keyF10] = "F10";
	keyName_[keyNumLock] = "NumLock";
	keyName_[keyScroll] = "Scroll";
	keyName_[keyNumPad7] = "NumPad7";
	keyName_[keyNumPad8] = "NumPad8";
	keyName_[keyNumPad9] = "NumPad9";
	keyName_[keyNumPadSubtract] = "NumPadSubtract";
	keyName_[keyNumPad4] = "NumPad4";
	keyName_[keyNumPad5] = "NumPad5";
	keyName_[keyNumPad6] = "NumPad6";
	keyName_[keyNumPadAdd] = "NumPadAdd";
	keyName_[keyNumPad1] = "NumPad1";
	keyName_[keyNumPad2] = "NumPad2";
	keyName_[keyNumPad3] = "NumPad3";
	keyName_[keyNumPad0] = "NumPad0";
	keyName_[keyNumPadDecimal] = "NumPadDecimal";
	keyName_[keyLeftBackslash] = "LeftBackslash";
	keyName_[keyF11] = "F11";
	keyName_[keyF12] = "F12";
	keyName_[keyF13] = "F13";
	keyName_[keyF14] = "F14";
	keyName_[keyF15] = "F15";
	keyName_[keyKana] = "Kana";
	keyName_[keyAbntC1] = "AbntC1";
	keyName_[keyConvert] = "Convert";
	keyName_[keyNoConvert] = "NoConvert";
	keyName_[keyYen] = "Yen";
	keyName_[keyNumPadAbntC2] = "NumPadAbntC2";
	keyName_[keyNumPadEquals98] = "NumPadEquals98";
	keyName_[keyPrevTrack] = "PrevTrack";
	keyName_[keyAtmark] = "Atmark";
	keyName_[keyColon] = "Colon";
	keyName_[keyUnderLine98] = "UnderLine98";
	keyName_[keyKanji] = "Kanji";
	keyName_[keyStop98] = "Stop98";
	keyName_[keyAx] = "Ax";
	keyName_[keyUnlabeled] = "Unlabeled";
	keyName_[keyNextTrack] = "NextTrack";
	keyName_[keyNumPadEnter] = "NumPadEnter";
	keyName_[keyRightControl] = "RightControl";
	keyName_[keyMute] = "Mute";
	keyName_[keyCalculator] = "Calculator";
	keyName_[keyPlayPause] = "PlayPause";
	keyName_[keyMediaStop] = "MediaStop";
	keyName_[keyVolumeDown] = "VolumeDown";
	keyName_[keyVolumeUp] = "VolumeUp";
	keyName_[keyWebHome] = "WebHome";
	keyName_[keyNumPadComma] = "NumPadComma";
	keyName_[keyNumPadDivide] = "NumPadDivide";
	keyName_[keyPrintScreen] = "PrintScreen";
	keyName_[keyRightAlt] = "RightAlt";
	keyName_[keyPause] = "Pause";
	keyName_[keyHome] = "Home";
	keyName_[keyUp] = "Up";
	keyName_[keyPageUp] = "PageUp";
	keyName_[keyLeft] = "Left";
	keyName_[keyRight] = "Right";
	keyName_[keyEnd] = "End";
	keyName_[keyDown] = "Down";
	keyName_[keyPageDown] = "PageDown";
	keyName_[keyInsert] = "Insert";
	keyName_[keyDelete] = "Delete";
	keyName_[keyLeftWin] = "LeftWin";
	keyName_[keyRightWin] = "RightWin";
	keyName_[keyApps] = "Apps";
	keyName_[keyPower] = "Power";
	keyName_[keySleep] = "Sleep";
	keyName_[keyWake] = "Wake";
	keyName_[keyWebSearch] = "WebSearch";
	keyName_[keyWebFavorites] = "WebFavorites";
	keyName_[keyWebRefresh] = "WebRefresh";
	keyName_[keyWebStop] = "WebStop";
	keyName_[keyWebForward] = "WebForward";
	keyName_[keyWebBack] = "WebBack";
	keyName_[keyMyComputer] = "MyComputer";
	keyName_[keyMail] = "Mail";
	keyName_[keyMediaSelect] = "MediaSelect";
	initialized_ = true;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
