//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * L[{[h
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Keyboard/Keyboard.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Keyboard::Keyboard(KeyboardDevice* device) : device_(device){
}
//------------------------------------------------------------------------------
// fXgN^
Keyboard::~Keyboard(){
}
//------------------------------------------------------------------------------
// ̃Xe[gݒ
void Keyboard::setNextState(const KeyboardState& state){
	preState_ = state_;
	state_ = state;
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String Keyboard::toString() const{
	String result, temp;
	result = getName();
	result += " (";
	if(isAttached()){ result += " Attached"; }
	if(isPolled()){ result += " NeedPolling"; }
	result += " )\n";
	// L[
	temp.format("Keys %d\n", getKeyCount());
	result += temp;

	result += " Press  ";
	for(int i = 0; i < maxKeyCount; i++){
		Key key = (Key)i;
		if(pressed(key)){ result += keyToString(key) + " "; }
	}
	result += "\n";

	result += " Down  ";
	for(int i = 0; i < maxKeyCount; i++){
		Key key = (Key)i;
		if(down(key)){ result += keyToString(key) + " "; }
	}
	result += "\n";

	result += " Up    ";
	for(int i = 0; i < maxKeyCount; i++){
		Key key = (Key)i;
		if(up(key)){ result += keyToString(key) + " "; }
	}
	result += "\n";
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
