//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WCXeBbNXe[g
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Joystick/JoystickState.h"
#include "Core/InputOutput/BinaryWriter.h"
#include "Core/InputOutput/BinaryReader.h"

namespace Lamp{

//------------------------------------------------------------------------------
// oCio
void JoystickState::writeBinary(BinaryWriter* binaryWriter) const{
	Assert(Limit::inShortRange(getXAxis()));
	Assert(Limit::inShortRange(getYAxis()));
	Assert(Limit::inShortRange(getZAxis()));
	Assert(Limit::inShortRange(getXRotation()));
	Assert(Limit::inShortRange(getYRotation()));
	Assert(Limit::inShortRange(getZRotation()));
	Assert(Limit::inShortRange(getSlider(0)));
	Assert(Limit::inShortRange(getSlider(1)));
	binaryWriter->writeShort(getXAxis());
	binaryWriter->writeShort(getYAxis());
	binaryWriter->writeShort(getZAxis());
	binaryWriter->writeShort(getXRotation());
	binaryWriter->writeShort(getYRotation());
	binaryWriter->writeShort(getZRotation());
	for(int i = 0; i < maxPOVCount; i++){ binaryWriter->writeInt(getPOV(i)); }
	for(int i = 0; i < maxSliderCount; i++){
		binaryWriter->writeShort(getSlider(i));
	}
	BitSet<u_int> buttonBit(0);
	for(int i = 0; i < maxButtonCount; i++){
		buttonBit.setIndexedBit(i, buttonPressed(i));
	}
	binaryWriter->writeUInt(buttonBit.getBits());
}
//------------------------------------------------------------------------------
// oCiǂݍ
void JoystickState::readBinary(BinaryReader* binaryReader){
	setXAxis(binaryReader->readShort());
	setYAxis(binaryReader->readShort());
	setZAxis(binaryReader->readShort());
	setXRotation(binaryReader->readShort());
	setYRotation(binaryReader->readShort());
	setZRotation(binaryReader->readShort());
	for(int i = 0; i < maxPOVCount; i++){ setPOV(i, binaryReader->readInt()); }
	for(int i = 0; i < maxSliderCount; i++){
		setSlider(i, binaryReader->readShort());
	}
	BitSet<u_int> buttonBit(binaryReader->readUInt());
	for(int i = 0; i < maxButtonCount; i++){
		setButtonPressed(i, buttonBit.getIndexedBit(i));
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
