//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WCXeBbNfoCX
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Joystick/JoystickDevice.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
JoystickDevice::JoystickDevice() : InputDevice(true), povCount_(0),
	sliderCount_(0), hasXAxis_(false), hasYAxis_(false), hasZAxis_(false),
	hasXRotation_(false), hasYRotation_(false), hasZRotation_(false){
}
//------------------------------------------------------------------------------
// fXgN^
JoystickDevice::~JoystickDevice(){
}
//------------------------------------------------------------------------------
// 
bool JoystickDevice::initialize(DirectInputDevice* inputDevice, HWND windowHandle){
	if(!InputDevice::initialize(inputDevice, windowHandle)){ return false; }
	// f[^tH[}bg̎w
	if(DirectXFailed(inputDevice->SetDataFormat(&c_dfDIJoystick2))){
		ErrorOut("JoystickDevice::initialize() "
			"WCXeBbNfoCX̃f[^tH[}bgwɎs܂B");
		return false;
	}
	// foCXIuWFNg̗
	if(DirectXFailed(inputDevice->EnumObjects(
		joystickObjectEnumeration, this, DIDFT_ALL))){
		ErrorOut("JoystickDevice::initialize() "
			"WCXeBbNfoCXIuWFNg̗񋓂Ɏs܂B");
		return false;
	}
	// Dx̎w
	if(!setCooperativeLevel(isExclusive(), isForeground())){ return false; }
	return true;
}
//------------------------------------------------------------------------------
// WCXeBbNIuWFNg̗񋓃R[obN
int __stdcall JoystickDevice::joystickObjectEnumeration(
	const DIDEVICEOBJECTINSTANCE* instance, void* userData){
	JoystickDevice* joystickDevice = (JoystickDevice* )userData;
	if(!joystickDevice->checkJoystickObject(instance)){ return DIENUM_STOP; }
	return DIENUM_CONTINUE;
}
//------------------------------------------------------------------------------
// WCXeBbNIuWFNg̃`FbN
bool JoystickDevice::checkJoystickObject(
	const DIDEVICEOBJECTINSTANCE* instance){
	// ͈̔͂ݒ肷
	if((instance->dwType & DIDFT_AXIS) != 0){
		DIPROPRANGE range;
		range.diph.dwSize = sizeof(DIPROPRANGE);
		range.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		range.diph.dwHow = DIPH_BYID;
		range.diph.dwObj = instance->dwType;
		range.lMin = minAxisValue;
		range.lMax = maxAxisValue;
		if(DirectXFailed(inputDevice_->SetProperty(DIPROP_RANGE, &range.diph))){
			ErrorOut("JoystickDevice::initialize() "
				"WCXeBbN͈̎͐ݒɎs܂B");
			return false;
		}
	}
	// XC_ȊO̎Ƀfbh][ƖOa][ݒ
	if(((instance->dwType & DIDFT_AXIS) != 0) &&
		(instance->guidType != GUID_Slider)){
		DIPROPDWORD property;
		property.diph.dwSize = sizeof(DIPROPDWORD);
		property.diph.dwHeaderSize = sizeof(DIPROPHEADER);
		property.diph.dwHow = DIPH_BYID;
		property.diph.dwObj = instance->dwType;
		property.dwData = deadZone_;
		if(DirectXFailed(inputDevice_->SetProperty(
			DIPROP_DEADZONE, &property.diph))){
			ErrorOut("JoystickDevice::initialize() "
				"WCXeBbÑfbh][ݒɎs܂B");
			return false;
		}
		property.dwData = saturationZone_;
		if(DirectXFailed(inputDevice_->SetProperty(
			DIPROP_SATURATION, &property.diph))){
			ErrorOut("JoystickDevice::initialize() "
				"WCXeBbN̖Oa][ݒɎs܂B");
			return false;
		}
	}
	// XĂ邩
	if(instance->guidType == GUID_XAxis){ hasXAxis_ = true; }
	// YĂ邩
	if(instance->guidType == GUID_YAxis){ hasYAxis_ = true; }
	// ZĂ邩
	if(instance->guidType == GUID_ZAxis){ hasZAxis_ = true; }
	// X]Ă邩
	if(instance->guidType == GUID_RxAxis){ hasXRotation_ = true; }
	// Y]Ă邩
	if(instance->guidType == GUID_RyAxis){ hasYRotation_ = true; }
	// Z]Ă邩
	if(instance->guidType == GUID_RzAxis){ hasZRotation_ = true; }
	// _Rg[
	if(instance->guidType == GUID_POV){ povCount_++; }
	// XC_
	if(instance->guidType == GUID_Slider){ sliderCount_++; }
	return true;
}
//------------------------------------------------------------------------------
// |[O
bool JoystickDevice::polling(){
	InputDevice::polling();
	// WCXeBbNfoCXXe[g擾
	DIJOYSTATE2 state;
	HRESULT result = inputDevice_->GetDeviceState(
		sizeof(DIJOYSTATE2), &state);
	if(DirectXSucceeded(result)){
		// Ƃ肠DIJOYSTATE͈̔͂ŃXe[g擾
		joystickState_.setXAxis(state.lX);
		joystickState_.setYAxis(state.lY);
		joystickState_.setZAxis(state.lZ);
		joystickState_.setXRotation(state.lRx);
		joystickState_.setYRotation(state.lRy);
		joystickState_.setZRotation(state.lRz);
		for(int i = 0; i < maxPOVCount; i++){
			joystickState_.setPOV(i, state.rgdwPOV[i]);
		}
		for(int i = 0; i < maxSliderCount; i++){
			joystickState_.setSlider(i, state.rglSlider[i]);
		}
		for(int i = 0; i < maxButtonCount; i++){
			joystickState_.setButtonPressed(i,
				((state.rgbButtons[i] & 0x80) != 0));
		}
		return true;
	}else{
		// G[Ȃ͖
		joystickState_.clear();
		// [ȃG[łȂ`FbN
		if((result != DIERR_INPUTLOST) && (result != DIERR_NOTACQUIRED)){
			ErrorOut("GetDeviceState()Ɏs܂B");
		}else{
			// foCXĎ擾
			acquire();
		}
	}
	return false;
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String JoystickDevice::toString() const{
	String result = getInputDeviceString();
	String joystickString;
	joystickString.format("Axis ( %d %d %d ) Rotation ( %d %d %d )  "
		"POV %d  Slider %d\n",
		hasXAxis(), hasYAxis(), hasZAxis(),
		hasXRotation(), hasYRotation(), hasZRotation(),
		getPOVCount(), getSliderCount());
	result += joystickString;
	result += joystickState_.toString();
	return result;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
