//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * WCXeBbN
 * @author Junpee
 */

#include "LampBasic.h"
#include "Input/Joystick/Joystick.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
Joystick::Joystick(JoystickDevice* device) : device_(device){
}
//------------------------------------------------------------------------------
// fXgN^
Joystick::~Joystick(){
}
//------------------------------------------------------------------------------
// ̃Xe[gݒ
void Joystick::setNextState(const JoystickState& state){
	preState_ = state_;
	state_ = state;
}
//------------------------------------------------------------------------------
// ւ̕ϊ
String Joystick::toString() const{
	String result, temp;
	result = getName();
	result += " (";
	if(isAttached()){ result += " Attached"; }
	if(isPolled()){ result += " NeedPolling"; }
	result += " )\n";
	// 
	temp.format("Axes %d ( Slider %d )\n", getAxisCount(), getSliderCount());
	result += temp;
	if(hasXAxis()){
		temp.format(" XAxis %.3f\n", getXAxis());
		result += temp;
	}
	if(hasYAxis()){
		temp.format(" YAxis %.3f\n", getYAxis());
		result += temp;
	}
	if(hasZAxis()){
		temp.format(" ZAxis %.3f\n", getZAxis());
		result += temp;
	}
	if(hasXRotation()){
		temp.format(" XRotation %.3f\n", getXRotation());
		result += temp;
	}
	if(hasYRotation()){
		temp.format(" YRotation %.3f\n", getYRotation());
		result += temp;
	}
	if(hasZRotation()){
		temp.format(" ZRotation %.3f\n", getZRotation());
		result += temp;
	}
	int sliderCount = getSliderCount();
	for(int i = 0; i < sliderCount; i++){
		temp.format(" Slider%d %.3f\n", i, getSlider(i)); 
		result += temp;
	}

	// POV
	int povCount = getPOVCount();
	temp.format("POVs %d", povCount);
	result += temp;
	if(povCount != 0){
		result += " (";
		for(int i = 0; i < povCount; i++){
			if(isPOVCenter(i)){
				result += "     C";
			}else{
				temp.format(" %5d", getPOV(i));
				result += temp;
			}
		}
		result += " )";
	}
	result += "\n";

	// {^
	int buttonCount = getButtonCount();
	temp.format("Buttons %d\n", getButtonCount());
	result += temp;
	result += " Press";
	for(int i = 0; i < buttonCount; i++){
		if(buttonPressed(i)){ result += " O"; }
		else{ result += " X"; }
	}
	result += "\n";
	result += " Down ";
	for(int i = 0; i < buttonCount; i++){
		if(buttonDown(i)){ result += " O"; }
		else{ result += " X"; }
	}
	result += "\n";
	result += " Up   ";
	for(int i = 0; i < buttonCount; i++){
		if(buttonUp(i)){ result += " O"; }
		else{ result += " X"; }
	}
	result += "\n";
	return result;
}

//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
