//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * r[|[gXvCgXe[g
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics2D/SpriteState/ViewportSpriteState.h"
#include "Graphics/Renderer/RenderingDevice.h"

namespace Lamp{

// 
const ViewportSpriteState ViewportSpriteState::disableState(
	RectangleI(0, 0, 0, 0));

// ftHg
const ViewportSpriteState ViewportSpriteState::defaultState(disableState);

//------------------------------------------------------------------------------
// RXgN^
ViewportSpriteState::ViewportSpriteState() : rectangle_(RectangleI::zero){
}
//------------------------------------------------------------------------------
// RXgN^
ViewportSpriteState::ViewportSpriteState(const RectangleI& rectangle) :
	rectangle_(rectangle){
}
//------------------------------------------------------------------------------
// fXgN^
ViewportSpriteState::~ViewportSpriteState(){
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// Kp
void ViewportSpriteState::apply(SpriteRenderState* renderState){
	RenderingDevice* device = RenderingDevice::getInstance();
	if(isEnabled()){
		device->setViewport(rectangle_);
	}else{
		device->resetViewport();
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
