//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * XvCgXe[gubN
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics2D/SpriteState/SpriteStateBlock.h"
#include "Graphics2D/Renderer/SpriteRenderer.h"
#include "Graphics2D/SpriteState/SpriteState.h"

namespace Lamp{

//------------------------------------------------------------------------------
// RXgN^
SpriteStateBlock::SpriteStateBlock(
	SpriteRenderer* spriteRenderer, int priority) :
	spriteRenderer_(spriteRenderer), priority_(priority){
}
//------------------------------------------------------------------------------
// RXgN^
SpriteStateBlock::SpriteStateBlock(SpriteRenderer* spriteRenderer) :
	spriteRenderer_(spriteRenderer){
	priority_ = spriteRenderer_->getDefaultPriority();
}
//------------------------------------------------------------------------------
// Xe[g̒ǉ
void SpriteStateBlock::addState(const SpriteState* spriteState){
	spriteRenderer_->request(spriteState, priority_);
	states_.add(spriteState);
}
//------------------------------------------------------------------------------
// fXgN^
SpriteStateBlock::~SpriteStateBlock(){
	int count = states_.getCount();
	for(int i = count - 1; i >= 0; i--){
		spriteRenderer_->request(states_.get(i)->getDefaultState(), priority_);
	}
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
