//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * FXvCgXe[g
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics2D/SpriteState/ColorSpriteState.h"
#include "Graphics/Renderer/RenderingDevice.h"

namespace Lamp{

// 
const ColorSpriteState ColorSpriteState::whiteState(Color4f(1.f, 1.f, 1.f));

// DF
const ColorSpriteState ColorSpriteState::grayState(Color4f(0.5f, 0.5f, 0.5f));

// 
const ColorSpriteState ColorSpriteState::blackState(Color4f(0.f, 0.f, 0.f));

// 
const ColorSpriteState ColorSpriteState::redState(Color4f(1.f, 0.f, 0.f));

// 
const ColorSpriteState ColorSpriteState::greenState(Color4f(0.f, 1.f, 0.f));

// 
const ColorSpriteState ColorSpriteState::blueState(Color4f(0.f, 0.f, 1.f));

// 
const ColorSpriteState ColorSpriteState::yellowState(Color4f(1.f, 1.f, 0.f));

// 
const ColorSpriteState ColorSpriteState::cyanState(Color4f(0.f, 1.f, 1.f));

// Ԏ
const ColorSpriteState ColorSpriteState::magentaState(Color4f(1.f, 0.f, 1.f));

// ftHg
const ColorSpriteState ColorSpriteState::defaultState(whiteState);

//------------------------------------------------------------------------------
// RXgN^
ColorSpriteState::ColorSpriteState() : color_(Color4f::white){
}
//------------------------------------------------------------------------------
// RXgN^
ColorSpriteState::ColorSpriteState(const Color4f& color) : color_(color){
}
//------------------------------------------------------------------------------
// fXgN^
ColorSpriteState::~ColorSpriteState(){
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// Kp
void ColorSpriteState::apply(SpriteRenderState* renderState){
	RenderingDevice* device = RenderingDevice::getInstance();
	Color4c color(Color4f(
		color_.r * 0.25f, color_.g * 0.25f, color_.b * 0.25f, color_.a));
	device->setRenderState(D3DRS_TEXTUREFACTOR, color.getARGB());
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
