//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * uhXvCgXe[g
 * @author Junpee
 */

#include "LampBasic.h"
#include "Graphics2D/SpriteState/BlendSpriteState.h"
#include "Graphics/Renderer/RenderingDevice.h"

namespace Lamp{

// 
const BlendSpriteState BlendSpriteState::translucent(blendModeAdd,
	blendStateSourceAlpha, blendStateInverseSourceAlpha);

// Z
const BlendSpriteState BlendSpriteState::addState(blendModeAdd,
	blendStateSourceAlpha, blendStateOne);

// ftHg
const BlendSpriteState BlendSpriteState::defaultState(translucent);

// uh[he[u
const String BlendSpriteState::blendModeStringTable[] = {
	"Disable",
	"Add",
	"Subtract",
	"InverseSubtract",
	"Minimum",
	"Maximum",
};

// uhXe[ge[u
const String BlendSpriteState::blendStateStringTable[] = {
	"Zero",
	"One",
	"SourceColor",
	"InverseSourceColor",
	"SourceAlpha",
	"InverseSourceAlpha",
	"SourceAlphaSaturate",
	"DestinationColor",
	"InverseDestinationColor",
	"DestinationAlpha",
	"InverseDestinationAlpha",
};

//------------------------------------------------------------------------------
// RXgN^
BlendSpriteState::BlendSpriteState() :
	blendMode_(blendModeAdd), blendSource_(blendStateSourceAlpha),
	blendDestination_(blendStateInverseSourceAlpha){
}
//------------------------------------------------------------------------------
// RXgN^
BlendSpriteState::BlendSpriteState(BlendMode blendMode,
	BlendState blendSource, BlendState blendDestination) :
	blendMode_(blendMode), blendSource_(blendSource),
	blendDestination_(blendDestination){
	Assert((blendMode_ >= 0) && (blendMode_ < blendModeMax));
	Assert((blendSource_ >= 0) && (blendSource_ < blendStateMax));
	Assert((blendDestination_ >= 0) && (blendDestination_ < blendStateMax));
}
//------------------------------------------------------------------------------
// fXgN^
BlendSpriteState::~BlendSpriteState(){
}
//------------------------------------------------------------------------------
// `
//------------------------------------------------------------------------------
// Kp
void BlendSpriteState::apply(SpriteRenderState* renderState){
	RenderingDevice* device = RenderingDevice::getInstance();
	if(blendMode_ == blendModeDisable){
		device->setBlending(false);
	}else{
		device->setBlending(true);
		device->setBlendMode(blendMode_, blendSource_, blendDestination_);
	}
}
//------------------------------------------------------------------------------
// uh[h
//------------------------------------------------------------------------------
// uh[h當ւ̕ϊ
const String& BlendSpriteState::blendModeToString(BlendMode blendMode){
	Assert(blendMode >= 0);
	Assert(blendMode < blendModeMax);
	return blendModeStringTable[blendMode];
}
//------------------------------------------------------------------------------
// 񂩂uh[hւ̕ϊ
BlendSpriteState::BlendMode BlendSpriteState::blendModeFromString(
	const String& blendModeString){
	for(int i = 0; i < blendModeMax; i++){
		if(blendModeStringTable[i].equals(blendModeString)){
			return BlendMode(i);
		}
	}
	ErrorOut("BlendSpriteState::blendModeFromString() " + blendModeString);
	return blendModeMax;
}
//------------------------------------------------------------------------------
// uhXe[g
//------------------------------------------------------------------------------
// uhXe[g當ւ̕ϊ
const String& BlendSpriteState::blendStateToString(BlendState blendState){
	Assert(blendState >= 0);
	Assert(blendState < blendStateMax);
	return blendStateStringTable[blendState];
}
//------------------------------------------------------------------------------
// 񂩂uhXe[gւ̕ϊ
BlendSpriteState::BlendState BlendSpriteState::blendStateFromString(
	const String& blendStateString){
	for(int i = 0; i < blendStateMax; i++){
		if(blendStateStringTable[i].equals(blendStateString)){
			return BlendState(i);
		}
	}
	ErrorOut("BlendSpriteState::blendStateFromString() " + blendStateString);
	return blendStateMax;
}
//------------------------------------------------------------------------------
} // End of namespace Lamp
//------------------------------------------------------------------------------
